/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.repoinit.createpath;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.repoinit.createpath.MixinParser;
import org.apache.sling.feature.cpconverter.repoinit.createpath.PrimaryTypeParser;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.repoinit.parser.operations.CreatePath;
import org.jetbrains.annotations.NotNull;

public class CreatePathSegmentProcessor {
    private CreatePathSegmentProcessor() {
    }

    public static boolean processSegments(@NotNull RepoPath path, @NotNull Collection<VaultPackageAssembler> packageAssemblers, @NotNull CreatePath cp) {
        String repositoryPath = "";
        boolean foundType = false;
        for (String part : path.getSegments()) {
            String platformName = PlatformNameFormat.getPlatformName((String)part);
            repositoryPath = repositoryPath.concat("/").concat(platformName);
            boolean segmentAdded = false;
            for (VaultPackageAssembler packageAssembler : packageAssemblers) {
                File currentContent = packageAssembler.getFileEntry(repositoryPath.concat("/").concat(".content.xml"));
                if (!currentContent.exists() || !currentContent.isFile() || !(segmentAdded = CreatePathSegmentProcessor.addSegment(cp, part, currentContent))) continue;
                foundType = true;
                break;
            }
            if (segmentAdded) continue;
            cp.addSegment(part, null);
        }
        return foundType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addSegment(@NotNull CreatePath cp, @NotNull String part, @NotNull File currentContent) {
        try (FileInputStream input = new FileInputStream(currentContent);
             FileInputStream input2 = new FileInputStream(currentContent);){
            String primary = (String)new PrimaryTypeParser().parse(input);
            if (primary == null) return false;
            ArrayList<String> mixins = new ArrayList<String>();
            String mixin = (String)new MixinParser().parse(input2);
            if (mixin != null) {
                if ((mixin = mixin.trim()).startsWith("[")) {
                    mixin = mixin.substring(1, mixin.length() - 1);
                }
                for (String m : mixin.split(",")) {
                    String mixinName = m.trim();
                    if (mixinName.isEmpty()) continue;
                    mixins.add(mixinName);
                }
            }
            cp.addSegment(part, primary, mixins);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException("A fatal error occurred while parsing the '" + currentContent + "' file, see nested exceptions: " + e);
        }
    }
}

