/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.index;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.sling.feature.cpconverter.index.IndexDefinitions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDefinitionsJsonWriter {
    private static final Function<String, JsonValue> BLOB_MAPPER = s -> Json.createValue((String)(":blobId:" + Base64.encode((String)s)));
    private static final Function<String, JsonValue> SAFE_LONG_MAPPER = new Function<String, JsonValue>(){

        @Override
        public JsonValue apply(String t) {
            if (t.endsWith(".0")) {
                t = t.replace(".0", "");
            }
            return Json.createValue((long)Long.parseLong(t));
        }
    };
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IndexDefinitions indexDefinitions;

    public IndexDefinitionsJsonWriter(@NotNull IndexDefinitions indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
    }

    public void writeAsJson(@NotNull OutputStream out) throws IOException {
        try (JsonGenerator root = Json.createGenerator((OutputStream)out);){
            root.writeStartObject();
            for (Map.Entry<String, List<DocViewNode2>> indexEntry : this.indexDefinitions.getIndexes().entrySet()) {
                for (DocViewNode2 index : indexEntry.getValue()) {
                    this.write(root, index, indexEntry.getKey());
                }
            }
            root.writeEnd();
        }
    }

    private void write(JsonGenerator json, DocViewNode2 index, String parentPath) throws IOException {
        String nodeName = this.indexDefinitions.toShortName(index.getName());
        String objectKey = parentPath.equals("/oak:index") ? "/oak:index/" + nodeName : nodeName;
        json.writeStartObject(objectKey);
        block11: for (DocViewProperty2 property : index.getProperties()) {
            String propertyName = this.indexDefinitions.toShortName(property.getName());
            switch (property.getType()) {
                case 0: 
                case 1: {
                    this.write(json, propertyName, property.getStringValues(), s -> Json.createValue((String)("str:" + s)));
                    continue block11;
                }
                case 3: {
                    this.write(json, propertyName, property.getStringValues(), SAFE_LONG_MAPPER);
                    continue block11;
                }
                case 6: {
                    this.write(json, propertyName, property.getStringValues(), s -> Boolean.parseBoolean(s) ? JsonValue.TRUE : JsonValue.FALSE);
                    continue block11;
                }
                case 7: {
                    this.write(json, propertyName, property.getStringValues(), s -> Json.createValue((String)("nam:" + s)));
                    continue block11;
                }
                case 4: {
                    this.write(json, propertyName, property.getStringValues(), s -> Json.createValue((double)Double.parseDouble(s)));
                    continue block11;
                }
                case 5: {
                    this.write(json, propertyName, property.getStringValues(), s -> Json.createValue((String)("dat:" + s)));
                    continue block11;
                }
                case 8: {
                    this.write(json, propertyName, property.getStringValues(), s -> Json.createValue((String)("pat:" + s)));
                    continue block11;
                }
                case 11: {
                    this.write(json, propertyName, property.getStringValues(), s -> Json.createValue((String)("uri:" + s)));
                    continue block11;
                }
                case 2: {
                    this.write(json, propertyName, property.getStringValues(), BLOB_MAPPER);
                    continue block11;
                }
            }
            this.logger.warn("Skipping property {}, don't know how to handle type {}; values: {}", new Object[]{property.getName(), property.getType(), property.getStringValues()});
        }
        String nodePath = parentPath + "/" + nodeName;
        Optional<byte[]> binary = this.indexDefinitions.getBinary(nodePath);
        if (binary.isPresent()) {
            this.write(json, "jcr:primaryType", Collections.singletonList("nt:file"), s -> Json.createValue((String)("nam:" + s)));
            json.writeStartObject("jcr:content");
            String blobAsString = new String(binary.get(), StandardCharsets.UTF_8);
            this.write(json, "jcr:primaryType", Collections.singletonList("nt:resource"), s -> Json.createValue((String)("nam:" + s)));
            this.write(json, "jcr:mimeType", Collections.singletonList(Files.probeContentType(Paths.get(nodePath, new String[0]))), Json::createValue);
            this.write(json, "jcr:data", Collections.singletonList(blobAsString), BLOB_MAPPER);
            json.writeEnd();
        }
        for (DocViewNode2 child : this.indexDefinitions.getChildren(nodePath)) {
            this.write(json, child, nodePath);
        }
        json.writeEnd();
    }

    private void write(JsonGenerator json, String propertyName, List<String> propertyValues, Function<String, JsonValue> mapper) {
        if (propertyValues.size() == 1) {
            json.write(propertyName, mapper.apply(propertyValues.get(0)));
            return;
        }
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        propertyValues.stream().map(mapper).forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        json.write(propertyName, (JsonValue)arrayBuilder.build());
    }
}

