/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultPackageAssembler
implements EntryHandler {
    private static final Pattern OSGI_BUNDLE_PATTERN = Pattern.compile("(jcr_root)?/apps/[^/]+/install(\\.([^/]+))?/.+\\.jar");
    public static final String VERSION_SUFFIX = "-cp2fm-converted";
    private static final Logger log = LoggerFactory.getLogger(VaultPackageAssembler.class);
    private final Set<String> convertedCpPaths = new HashSet<String>();
    private final Set<String> allPaths = new HashSet<String>();
    private final DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
    private final Set<Dependency> dependencies;
    private final File storingDirectory;
    private final Properties properties;
    private final File tmpDir;
    private final boolean removeInstallHooks;

    private VaultPackageAssembler(@NotNull File tempDir, @NotNull File storingDirectory, @NotNull Properties properties, @NotNull Set<Dependency> dependencies, boolean removeInstallHooks) {
        this.storingDirectory = storingDirectory;
        this.properties = properties;
        this.dependencies = dependencies;
        this.tmpDir = tempDir;
        this.removeInstallHooks = removeInstallHooks;
    }

    @NotNull
    public static VaultPackageAssembler create(@NotNull File baseTempDir, @NotNull VaultPackage vaultPackage, boolean removeInstallHooks) {
        File tempDir = new File(baseTempDir, "synthetic-content-packages_" + System.currentTimeMillis());
        PackageId packageId = vaultPackage.getId();
        File storingDirectory = VaultPackageAssembler.initStoringDirectory(packageId, tempDir);
        Properties properties = new Properties();
        Map<Object, Object> originalPackageProperties = vaultPackage.getMetaInf().getProperties();
        if (originalPackageProperties == null) {
            throw new IllegalArgumentException("No package properties found in " + vaultPackage.getId());
        }
        if (removeInstallHooks) {
            log.info("Removing install hooks from original package");
            originalPackageProperties = originalPackageProperties.entrySet().stream().filter(new RemoveInstallHooksPredicate()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        properties.putAll(originalPackageProperties);
        String version = vaultPackage.getId().getVersion().toString();
        if (!version.endsWith(VERSION_SUFFIX)) {
            version = version + VERSION_SUFFIX;
        }
        properties.setProperty("version", version);
        Set<Dependency> dependencies = VaultPackageUtils.getDependencies(vaultPackage);
        VaultPackageAssembler assembler = new VaultPackageAssembler(tempDir, storingDirectory, properties, dependencies, removeInstallHooks);
        assembler.mergeFilters(Objects.requireNonNull(vaultPackage.getMetaInf().getFilter()));
        return assembler;
    }

    @NotNull
    public static VaultPackageAssembler create(@NotNull File baseTempDir, @NotNull PackageId packageId, String description) {
        File tempDir = new File(baseTempDir, "synthetic-content-packages_" + System.currentTimeMillis());
        File storingDirectory = VaultPackageAssembler.initStoringDirectory(packageId, tempDir);
        Properties props = new Properties();
        props.put("group", packageId.getGroup());
        props.put("name", packageId.getName());
        props.put("version", packageId.getVersionString() + VERSION_SUFFIX);
        props.put("description", description);
        return new VaultPackageAssembler(tempDir, storingDirectory, props, new HashSet<Dependency>(), false);
    }

    @NotNull
    private static File initStoringDirectory(PackageId packageId, @NotNull File tempDir) {
        File jcrRootDirectory;
        String fileName = packageId.toString().replace('/', '-').replace(':', '-');
        File storingDirectory = new File(tempDir, fileName + "-deflated");
        if (storingDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)storingDirectory);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to delete existing deflated folder: '" + storingDirectory + "'", e);
            }
        }
        if (!(jcrRootDirectory = new File(storingDirectory, "jcr_root")).mkdirs() && jcrRootDirectory.isDirectory()) {
            throw new IllegalStateException("Unable to create jcr root dir: " + jcrRootDirectory);
        }
        return storingDirectory;
    }

    File getTempDir() {
        return this.tmpDir;
    }

    @Override
    public boolean matches(@NotNull String path) {
        return true;
    }

    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws Exception {
        if (this.removeInstallHooks && path.startsWith("/META-INF/vault/hooks")) {
            log.info("Skipping install hook {} from original package", (Object)path);
        } else {
            this.addEntry(path, archive, entry);
        }
    }

    @NotNull
    public Properties getPackageProperties() {
        return this.properties;
    }

    public void mergeFilters(@NotNull WorkspaceFilter filter) {
        for (PathFilterSet pathFilterSet : filter.getFilterSets()) {
            if (OSGI_BUNDLE_PATTERN.matcher(pathFilterSet.getRoot()).matches()) continue;
            this.filter.add(pathFilterSet);
        }
    }

    public DefaultWorkspaceFilter getFilter() {
        return this.filter;
    }

    public void addEntry(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry) throws IOException {
        try (InputStream input = Objects.requireNonNull(archive.openInputStream(entry));){
            this.addEntry(path, input);
        }
    }

    public void addEntry(@NotNull String path, @NotNull File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            this.addEntry(path, input);
        }
    }

    public void addEntry(@NotNull String path, @NotNull InputStream input) throws IOException {
        try (OutputStream output = this.createEntry(path);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    @NotNull
    public OutputStream createEntry(@NotNull String path) throws IOException {
        File target = new File(this.storingDirectory, path);
        if (!target.getParentFile().mkdirs() && !target.getParentFile().isDirectory()) {
            throw new IOException("Could not create parent directory: " + target.getParentFile());
        }
        this.convertedCpPaths.add(path);
        return new FileOutputStream(target);
    }

    @NotNull
    public File getEntry(@NotNull String path) {
        if (!path.startsWith("jcr_root")) {
            path = "jcr_root" + path;
        }
        return new File(this.storingDirectory, path);
    }

    public boolean recordEntryPath(@NotNull String entryPath) {
        return this.allPaths.add(entryPath);
    }

    public void updateDependencies(@NotNull Map<PackageId, Set<Dependency>> mutableContentsIds) {
        HashMap<Dependency, Set<Dependency>> matches = new HashMap<Dependency, Set<Dependency>>();
        for (Dependency dependency : this.dependencies) {
            for (Map.Entry<PackageId, Set<Dependency>> mutableContentId : mutableContentsIds.entrySet()) {
                if (!dependency.matches(mutableContentId.getKey())) continue;
                matches.put(dependency, mutableContentId.getValue());
            }
        }
        for (Map.Entry entry : matches.entrySet()) {
            this.dependencies.remove(entry.getKey());
            this.dependencies.addAll((Collection)entry.getValue());
        }
    }

    public void addDependency(@NotNull Dependency dependency) {
        this.dependencies.add(dependency);
    }

    @NotNull
    public File createPackage() throws IOException {
        return this.createPackage(false);
    }

    @NotNull
    public File createPackage(boolean generateFilters) throws IOException {
        File metaDir = new File(this.storingDirectory, "META-INF/vault");
        if (!metaDir.exists() && !metaDir.mkdirs()) {
            throw new IOException("Could not create meta Dir: " + metaDir);
        }
        String sourcePackageTypeValue = (String)this.properties.get("packageType");
        PackageType sourcePackageType = sourcePackageTypeValue != null ? PackageType.valueOf((String)sourcePackageTypeValue.toUpperCase()) : null;
        PackageType newPackageType = VaultPackageUtils.recalculatePackageType(sourcePackageType, this.storingDirectory);
        if (newPackageType != null) {
            this.properties.setProperty("packageType", newPackageType.name().toLowerCase());
        }
        VaultPackageUtils.setDependencies(this.dependencies, this.properties);
        File xmlProperties = new File(metaDir, "properties.xml");
        try (FileOutputStream fos = new FileOutputStream(xmlProperties);){
            this.properties.storeToXML(fos, null);
        }
        if (generateFilters) {
            this.computeFilters(this.storingDirectory);
        }
        Set<String> allRepoPaths = VaultPackageAssembler.toRepositoryPaths(this.allPaths);
        Set<String> convertedCpRepoPaths = VaultPackageAssembler.toRepositoryPaths(this.convertedCpPaths);
        HashSet<String> filteredPaths = new HashSet<String>(allRepoPaths);
        filteredPaths.removeAll(convertedCpRepoPaths);
        WorkspaceFilter adjustedFilter = VaultPackageAssembler.createAdjustedFilter((WorkspaceFilter)this.filter, filteredPaths, convertedCpRepoPaths);
        File xmlFilter = new File(metaDir, "filter.xml");
        try (InputStream input = adjustedFilter.getSource();
             FileOutputStream output = new FileOutputStream(xmlFilter);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        String destFileName = this.storingDirectory.getName().substring(0, this.storingDirectory.getName().lastIndexOf(45));
        File destFile = new File(this.tmpDir, destFileName);
        File manifestFile = new File(this.storingDirectory, "META-INF/MANIFEST.MF".replace('/', File.separatorChar));
        Manifest manifest = null;
        if (manifestFile.exists()) {
            try (FileInputStream r = new FileInputStream(manifestFile);){
                manifest = new Manifest(r);
            }
        }
        try (JarOutputStream jos = manifest == null ? new JarOutputStream(new FileOutputStream(destFile)) : new JarOutputStream((OutputStream)new FileOutputStream(destFile), manifest);){
            jos.setLevel(-1);
            VaultPackageAssembler.addDirectory(jos, this.storingDirectory, this.storingDirectory.getAbsolutePath().length() + 1);
        }
        return destFile;
    }

    @NotNull
    private static Set<String> toRepositoryPaths(@NotNull Set<String> paths) {
        return paths.stream().map(s -> {
            if (s.startsWith("/jcr_root")) {
                return s.substring("/jcr_root".length());
            }
            return s;
        }).collect(Collectors.toSet());
    }

    @NotNull
    private static WorkspaceFilter createAdjustedFilter(@NotNull WorkspaceFilter base, @NotNull Set<String> filteredPaths, @NotNull Set<String> cpPaths) throws IOException {
        try {
            DefaultWorkspaceFilter dwf = new DefaultWorkspaceFilter();
            for (PathFilterSet pfs : base.getPropertyFilterSets()) {
                VaultPackageAssembler.processPathFilterSet(pfs, dwf, true, filteredPaths, cpPaths);
            }
            for (PathFilterSet pfs : base.getFilterSets()) {
                VaultPackageAssembler.processPathFilterSet(pfs, dwf, false, filteredPaths, cpPaths);
            }
            return dwf;
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
    }

    private static void processPathFilterSet(@NotNull PathFilterSet pfs, @NotNull DefaultWorkspaceFilter newFilter, boolean isPropertyFilterSet, @NotNull Set<String> filteredPaths, @NotNull Set<String> cpPaths) throws ConfigurationException {
        if (cpPaths.stream().noneMatch(arg_0 -> ((PathFilterSet)pfs).covers(arg_0))) {
            return;
        }
        PathFilterSet filterSet = new PathFilterSet(pfs.getRoot());
        filterSet.setType(pfs.getType());
        for (FilterSet.Entry entry : pfs.getEntries()) {
            if (entry.isInclude()) {
                filterSet.addInclude((Filter)((PathFilter)entry.getFilter()));
                continue;
            }
            filterSet.addExclude((Filter)((PathFilter)entry.getFilter()));
        }
        for (String path : filteredPaths) {
            if (!pfs.covers(path)) continue;
            filterSet.addExclude((Filter)new DefaultPathFilter(path));
        }
        if (isPropertyFilterSet) {
            newFilter.addPropertyFilterSet(filterSet);
        } else {
            newFilter.add(filterSet);
        }
    }

    private static void addDirectory(@NotNull JarOutputStream jos, @NotNull File dir, int prefixLength) throws IOException {
        if (dir.getAbsolutePath().length() > prefixLength && dir.listFiles().length == 0) {
            String dirName = dir.getAbsolutePath().substring(prefixLength).replace(File.separatorChar, '/');
            JarEntry entry = new JarEntry(dirName);
            entry.setTime(dir.lastModified());
            entry.setSize(0L);
            jos.putNextEntry(entry);
            jos.closeEntry();
        }
        for (File f : dir.listFiles()) {
            String name = f.getAbsolutePath().substring(prefixLength).replace(File.separatorChar, '/');
            if (f.isFile() && !"META-INF/MANIFEST.MF".equals(name)) {
                JarEntry entry = new JarEntry(name);
                entry.setTime(f.lastModified());
                jos.putNextEntry(entry);
                try (FileInputStream in = new FileInputStream(f);){
                    IOUtils.copy((InputStream)in, (OutputStream)jos);
                }
                jos.closeEntry();
                continue;
            }
            if (!f.isDirectory()) continue;
            VaultPackageAssembler.addDirectory(jos, f, prefixLength);
        }
    }

    private void computeFilters(@NotNull File outputDirectory) {
        VaultPackageUtils.forEachDirectoryBelowJcrRoot(outputDirectory, (child, base) -> {
            File lowestCommonAncestor;
            TreeNode node = VaultPackageAssembler.lowestCommonAncestor(new TreeNode((File)child));
            File file = lowestCommonAncestor = node != null ? node.val : null;
            if (lowestCommonAncestor != null) {
                String root = "/" + PlatformNameFormat.getRepositoryPath((String)base.toURI().relativize(lowestCommonAncestor.toURI()).getPath(), (boolean)true);
                this.filter.add(new PathFilterSet(root));
            }
        });
    }

    @Nullable
    private static TreeNode lowestCommonAncestor(@NotNull TreeNode root) {
        int currMaxDepth = 0;
        int countMaxDepth = 0;
        TreeNode node = null;
        for (File child : root.val.listFiles((FileFilter)DirectoryFileFilter.INSTANCE)) {
            TreeNode temp = VaultPackageAssembler.lowestCommonAncestor(new TreeNode(child));
            if (temp == null) continue;
            if (temp.maxDepth > currMaxDepth) {
                currMaxDepth = temp.maxDepth;
                node = temp;
                countMaxDepth = 1;
                continue;
            }
            if (temp.maxDepth != currMaxDepth) continue;
            ++countMaxDepth;
        }
        if (countMaxDepth > 1) {
            root.maxDepth = node.maxDepth + 1;
            return root;
        }
        if (countMaxDepth == 1) {
            ++node.maxDepth;
            return node;
        }
        if (countMaxDepth == 0) {
            root.maxDepth = 2;
            return root;
        }
        return null;
    }

    private static final class RemoveInstallHooksPredicate
    implements Predicate<Map.Entry<Object, Object>> {
        private RemoveInstallHooksPredicate() {
        }

        @Override
        public boolean test(Map.Entry<Object, Object> entry) {
            String key = (String)entry.getKey();
            return !key.startsWith("installhook.");
        }
    }

    private static final class TreeNode {
        File val;
        int maxDepth;

        TreeNode(@NotNull File x) {
            this.val = x;
            this.maxDepth = 0;
        }
    }
}

