/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.Map;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.AbstractContentPackageHandler;
import org.apache.sling.feature.cpconverter.vltpkg.RecollectorVaultPackageScanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionResolverContentPackageEntryHandler
extends AbstractContentPackageHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RecollectorVaultPackageScanner scanner;
    private final Map<PackageId, String> subContentPackages;

    public VersionResolverContentPackageEntryHandler(@NotNull RecollectorVaultPackageScanner scanner, @NotNull Map<PackageId, String> subContentPackages) {
        this.scanner = scanner;
        this.subContentPackages = subContentPackages;
    }

    @Override
    protected void processSubPackage(@NotNull String path, @Nullable String runMode, @NotNull VaultPackage contentPackage, @NotNull ContentPackage2FeatureModelConverter converter, boolean isEmbeddedPackage) throws Exception {
        boolean addPackage;
        PackageId currentId = contentPackage.getId();
        this.logger.info("Checking if other {}:{} content-package versions were handled already", (Object)currentId.getGroup(), (Object)currentId.getName());
        PackageId olderId = this.getPackage(currentId);
        if (olderId != null) {
            this.logger.info("Comparing {}:{} package versions: current one is {}, previous one is {} ", new Object[]{currentId.getGroup(), currentId.getName(), currentId.getVersionString(), olderId.getVersionString()});
            boolean bl = addPackage = currentId.compareTo(olderId) > 0;
            if (addPackage) {
                this.logger.info("Replacing version {} of content-package {}:{} with version {}", new Object[]{olderId.getVersionString(), currentId.getGroup(), currentId.getName(), currentId.getVersionString()});
                this.subContentPackages.remove(olderId);
            }
        } else {
            this.logger.info("There were not other version of {}:{} content-package", (Object)currentId.getGroup(), (Object)currentId.getName());
            addPackage = true;
        }
        if (addPackage) {
            this.subContentPackages.put(currentId, path);
            this.scanner.traverse(contentPackage);
        }
    }

    @Nullable
    private PackageId getPackage(@NotNull PackageId expectedId) {
        for (PackageId currentId : this.subContentPackages.keySet()) {
            if (!expectedId.getGroup().equals(currentId.getGroup()) || !expectedId.getName().equals(currentId.getName())) continue;
            return currentId;
        }
        return null;
    }
}

