/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.AbstractUserParser;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.jetbrains.annotations.NotNull;

abstract class AbstractUserEntryHandler
extends AbstractRegexEntryHandler {
    private String systemUserSegment = AbstractUserEntryHandler.createSegment("system");

    AbstractUserEntryHandler(@NotNull String rexex) {
        super(rexex);
    }

    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws Exception {
        Matcher matcher = this.getPattern().matcher(path);
        if (matcher.matches()) {
            RepoPath originalPath = new RepoPath(PlatformNameFormat.getRepositoryPath((String)matcher.group(1)));
            RepoPath intermediatePath = originalPath.getParent();
            byte[] tmp = IOUtils.toByteArray((InputStream)archive.openInputStream(entry));
            AbstractUserParser parser = this.createParser(converter, originalPath, intermediatePath);
            boolean converted = (Boolean)parser.parse(new ByteArrayInputStream(tmp));
            if (!converted && !path.contains(this.systemUserSegment) && converter.hasMainPackageAssembler()) {
                VaultPackageAssembler assembler = converter.getMainPackageAssembler();
                try (ByteArrayInputStream input = new ByteArrayInputStream(tmp);
                     OutputStream output = assembler.createEntry(path);){
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
            }
        }
    }

    abstract AbstractUserParser createParser(@NotNull ContentPackage2FeatureModelConverter var1, @NotNull RepoPath var2, @NotNull RepoPath var3);

    void setSystemUserRelPath(@NotNull String systemUserRelPath) {
        int index = systemUserRelPath.indexOf(47);
        this.systemUserSegment = index == -1 ? AbstractUserEntryHandler.createSegment(systemUserRelPath) : AbstractUserEntryHandler.createSegment(systemUserRelPath.substring(0, index));
    }

    private static String createSegment(@NotNull String relPath) {
        return "/" + relPath + "/";
    }
}

