/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config.validation;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.Option;
import org.apache.sling.feature.extension.apiregions.api.config.PlaceholderPolicy;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyType;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;

public class PropertyValidator {
    private boolean liveValues = false;
    private static final List<String> PLACEHOLDERS = Arrays.asList("$[env:", "$[secret:", "$[prop:");

    public boolean isLiveValues() {
        return this.liveValues;
    }

    public void setLiveValues(boolean value) {
        this.liveValues = value;
    }

    public PropertyValidationResult validate(Object value, PropertyDescription desc) {
        return this.validate(value, desc, Mode.STRICT);
    }

    public PropertyValidationResult validate(Object value, PropertyDescription desc, Mode mode) {
        Context context = new Context();
        context.description = desc;
        Mode mode2 = desc.getMode() != null ? desc.getMode() : (context.validationMode = mode != null ? mode : Mode.STRICT);
        if (value == null) {
            if (desc.isRequired()) {
                this.setResult(context, "No value provided");
            }
        } else {
            ArrayList<Object> values;
            if (value.getClass().isArray()) {
                values = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    values.add(Array.get(value, i));
                }
            } else if (value instanceof Collection) {
                values = new ArrayList();
                Collection c = (Collection)value;
                for (Object o : c) {
                    values.add(o);
                }
            } else {
                values = null;
                this.validateValue(context, value);
            }
            if (values != null) {
                for (Object e : values) {
                    this.validateValue(context, e);
                }
                this.validateList(context, values);
            }
            if (desc.getDeprecated() != null) {
                context.result.getWarnings().add(desc.getDeprecated());
            }
        }
        return context.result;
    }

    void setResult(Context context, String msg) {
        PropertyValidator.setResult(context.result, context.description.getDefaultValue(), context.validationMode, msg);
    }

    static void setResult(PropertyValidationResult result, Object defaultValue, Mode validationMode, String msg) {
        if (validationMode == Mode.STRICT) {
            result.getErrors().add(msg);
        } else if (validationMode == Mode.LENIENT || validationMode == Mode.DEFINITIVE) {
            result.getWarnings().add(msg);
        }
        if (validationMode == Mode.DEFINITIVE || validationMode == Mode.SILENT_DEFINITIVE) {
            result.setUseDefaultValue(true);
            result.setDefaultValue(defaultValue);
        }
    }

    void validateList(Context context, List<Object> values) {
        boolean found;
        if (context.description.getCardinality() > 0 && values.size() > context.description.getCardinality()) {
            this.setResult(context, "Array/collection contains too many elements, only " + context.description.getCardinality() + " allowed");
        }
        if (context.description.getIncludes() != null) {
            for (String inc : context.description.getIncludes()) {
                found = false;
                for (Object val : values) {
                    if (!inc.equals(val.toString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.setResult(context, "Required included value " + inc + " not found");
            }
        }
        if (context.description.getExcludes() != null) {
            for (String exc : context.description.getExcludes()) {
                found = false;
                for (Object val : values) {
                    if (!exc.equals(val.toString())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                this.setResult(context, "Required excluded value " + exc + " found");
            }
        }
    }

    void validateValue(Context context, Object value) {
        if (value != null) {
            boolean hasPlaceholder = false;
            if (value instanceof String) {
                String strVal = (String)value;
                for (String p : PLACEHOLDERS) {
                    if (!strVal.contains(p)) continue;
                    hasPlaceholder = true;
                    break;
                }
            }
            if (!hasPlaceholder) {
                switch (context.description.getType()) {
                    case BOOLEAN: {
                        this.validateBoolean(context, value);
                        break;
                    }
                    case BYTE: {
                        this.validateByte(context, value);
                        break;
                    }
                    case CHARACTER: {
                        this.validateCharacter(context, value);
                        break;
                    }
                    case DOUBLE: {
                        this.validateDouble(context, value);
                        break;
                    }
                    case FLOAT: {
                        this.validateFloat(context, value);
                        break;
                    }
                    case INTEGER: {
                        this.validateInteger(context, value);
                        break;
                    }
                    case LONG: {
                        this.validateLong(context, value);
                        break;
                    }
                    case SHORT: {
                        this.validateShort(context, value);
                        break;
                    }
                    case STRING: {
                        this.validateRequired(context, value);
                        break;
                    }
                    case EMAIL: {
                        this.validateEmail(context, value);
                        break;
                    }
                    case PASSWORD: {
                        this.validatePassword(context, value, false);
                        break;
                    }
                    case URL: {
                        this.validateURL(context, value);
                        break;
                    }
                    case PATH: {
                        this.validatePath(context, value);
                        break;
                    }
                    default: {
                        context.result.getErrors().add("Unable to validate value - unknown property type : " + (Object)((Object)context.description.getType()));
                    }
                }
                this.validateRegex(context, context.description.getRegexPattern(), value);
                this.validateOptions(context, value);
                if (context.description.getType() != PropertyType.PASSWORD) {
                    this.validatePlaceholderPolicy(context, value, false);
                }
            } else {
                if (context.description.getType() == PropertyType.PASSWORD) {
                    this.validatePassword(context, value, true);
                } else if (context.description.getType() == PropertyType.STRING) {
                    this.validateRegex(context, context.description.getPlaceholderRegexPattern(), value);
                    if (context.description.getRegex() != null || context.description.getOptions() != null || context.description.isRequired()) {
                        context.result.markSkipped();
                    }
                } else {
                    context.result.markSkipped();
                }
                if (context.description.getType() != PropertyType.PASSWORD) {
                    this.validatePlaceholderPolicy(context, value, true);
                }
            }
        } else {
            this.setResult(context, "Null value provided for validation");
        }
    }

    void validateRequired(Context context, Object value) {
        String val;
        if (context.description.isRequired() && (val = value.toString()).isEmpty()) {
            this.setResult(context, "Value is required");
        }
    }

    void validateBoolean(Context context, Object value) {
        if (!(value instanceof Boolean)) {
            if (value instanceof String) {
                String v = (String)value;
                if (!v.equalsIgnoreCase("true") && !v.equalsIgnoreCase("false")) {
                    this.setResult(context, "Boolean value must either be true or false, but not " + value);
                }
            } else {
                this.setResult(context, "Boolean value must either be of type Boolean or String : " + value);
            }
        }
    }

    void validateByte(Context context, Object value) {
        if (!(value instanceof Byte)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, Byte.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, "Value is not a valid Byte : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, ((Number)value).byteValue());
            } else {
                this.setResult(context, "Byte value must either be of type Byte or String : " + value);
            }
        } else {
            this.validateRange(context, (Byte)value);
        }
    }

    void validateShort(Context context, Object value) {
        if (!(value instanceof Short)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, Short.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, "Value is not a valid Short : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, ((Number)value).shortValue());
            } else {
                this.setResult(context, "Short value must either be of type Short or String : " + value);
            }
        } else {
            this.validateRange(context, (Short)value);
        }
    }

    void validateInteger(Context context, Object value) {
        if (!(value instanceof Integer)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, Integer.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, "Value is not a valid Integer : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, ((Number)value).intValue());
            } else {
                this.setResult(context, "Integer value must either be of type Integer or String : " + value);
            }
        } else {
            this.validateRange(context, (Integer)value);
        }
    }

    void validateLong(Context context, Object value) {
        if (!(value instanceof Long)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, Long.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, "Value is not a valid Long : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, ((Number)value).longValue());
            } else {
                this.setResult(context, "Long value must either be of type Long or String : " + value);
            }
        } else {
            this.validateRange(context, (Long)value);
        }
    }

    void validateFloat(Context context, Object value) {
        if (!(value instanceof Float)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, Float.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, "Value is not a valid Float : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, Float.valueOf(((Number)value).floatValue()));
            } else {
                this.setResult(context, "Float value must either be of type Float or String : " + value);
            }
        } else {
            this.validateRange(context, (Float)value);
        }
    }

    void validateDouble(Context context, Object value) {
        if (!(value instanceof Double)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, Double.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, "Value is not a valid Double : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, ((Number)value).doubleValue());
            } else {
                this.setResult(context, "Double value must either be of type Double or String : " + value);
            }
        } else {
            this.validateRange(context, (Double)value);
        }
    }

    void validateCharacter(Context context, Object value) {
        if (!(value instanceof Character)) {
            if (value instanceof String) {
                String v = (String)value;
                if (v.length() > 1) {
                    this.setResult(context, "Value is not a valid Character : " + value);
                }
            } else {
                this.setResult(context, "Character value must either be of type Character or String : " + value);
            }
        }
    }

    void validateURL(Context context, Object value) {
        String val = value.toString();
        try {
            new URL(val);
        }
        catch (MalformedURLException mue) {
            this.setResult(context, "Value is not a valid URL : " + val);
        }
    }

    void validateEmail(Context context, Object value) {
        String val = value.toString();
        if (!val.contains("@")) {
            this.setResult(context, "Not a valid email address " + val);
        }
    }

    void validatePassword(Context context, Object value, boolean hasPlaceholder) {
        if (!this.isLiveValues() && !hasPlaceholder && context.description.getPlaceholderPolicy() != PlaceholderPolicy.DENY) {
            this.setResult(context, "Value for a password must use a placeholder");
        }
    }

    void validatePath(Context context, Object value) {
        String val = value.toString();
        if (!val.startsWith("/")) {
            this.setResult(context, "Not a valid path " + val);
        }
    }

    void validateRange(Context context, Number value) {
        if (context.description.getRange() != null) {
            if (context.description.getRange().getMin() != null) {
                if (value instanceof Float || value instanceof Double) {
                    double min = context.description.getRange().getMin().doubleValue();
                    if (value.doubleValue() < min) {
                        this.setResult(context, "Value " + value + " is too low; should not be lower than " + context.description.getRange().getMin());
                    }
                } else {
                    long min = context.description.getRange().getMin().longValue();
                    if (value.longValue() < min) {
                        this.setResult(context, "Value " + value + " is too low; should not be lower than " + context.description.getRange().getMin());
                    }
                }
            }
            if (context.description.getRange().getMax() != null) {
                if (value instanceof Float || value instanceof Double) {
                    double max = context.description.getRange().getMax().doubleValue();
                    if (value.doubleValue() > max) {
                        this.setResult(context, "Value " + value + " is too high; should not be higher than " + context.description.getRange().getMax());
                    }
                } else {
                    long max = context.description.getRange().getMax().longValue();
                    if (value.longValue() > max) {
                        this.setResult(context, "Value " + value + " is too high; should not be higher than " + context.description.getRange().getMax());
                    }
                }
            }
        }
    }

    void validateRegex(Context context, Pattern pattern, Object value) {
        if (pattern != null && !pattern.matcher(value.toString()).matches()) {
            this.setResult(context, "Value " + value + " does not match regex " + pattern.pattern());
        }
    }

    void validateOptions(Context context, Object value) {
        if (context.description.getOptions() != null) {
            boolean found = false;
            for (Option opt : context.description.getOptions()) {
                if (!opt.getValue().equals(value.toString())) continue;
                found = true;
            }
            if (!found) {
                this.setResult(context, "Value " + value + " does not match provided options");
            }
        }
    }

    void validatePlaceholderPolicy(Context context, Object value, boolean hasPlaceholder) {
        if (!this.isLiveValues()) {
            if (context.description.getPlaceholderPolicy() == PlaceholderPolicy.DENY && hasPlaceholder) {
                this.setResult(context, "Placeholder in value is not allowed");
            } else if (context.description.getPlaceholderPolicy() == PlaceholderPolicy.REQUIRE && !hasPlaceholder) {
                this.setResult(context, "Value must use a placeholder");
            }
        }
    }

    static final class Context {
        public final PropertyValidationResult result = new PropertyValidationResult();
        public PropertyDescription description;
        public Mode validationMode;

        Context() {
        }
    }
}

