/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionState;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.apiregions.api.config.AttributeableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.FrameworkPropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Region;

public class ConfigurationApi
extends AttributeableEntity {
    public static final String EXTENSION_NAME = "configuration-api";
    private final Map<String, ConfigurationDescription> configurations = new LinkedHashMap<String, ConfigurationDescription>();
    private final Map<String, FactoryConfigurationDescription> factories = new LinkedHashMap<String, FactoryConfigurationDescription>();
    private final Map<String, FrameworkPropertyDescription> frameworkProperties = new LinkedHashMap<String, FrameworkPropertyDescription>();
    private final Set<String> internalConfigurations = new TreeSet<String>();
    private final Set<String> internalFactories = new TreeSet<String>();
    private final Set<String> internalFrameworkProperties = new TreeSet<String>();
    private Region region;
    private final Map<ArtifactId, Region> regionCache = new LinkedHashMap<ArtifactId, Region>();
    private Mode mode;

    public static ConfigurationApi getConfigurationApi(Feature feature) {
        Extension ext = feature == null ? null : feature.getExtensions().getByName(EXTENSION_NAME);
        return ConfigurationApi.getConfigurationApi(ext);
    }

    public static ConfigurationApi getConfigurationApi(Extension ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getType() != ExtensionType.JSON) {
            throw new IllegalArgumentException("Extension " + ext.getName() + " must have JSON type");
        }
        try {
            ConfigurationApi result = new ConfigurationApi();
            result.fromJSONObject(ext.getJSONStructure().asJsonObject());
            return result;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage(), ioe);
        }
    }

    public static void setConfigurationApi(Feature feature, ConfigurationApi api) {
        Extension ext = feature.getExtensions().getByName(EXTENSION_NAME);
        if (api == null) {
            if (ext != null) {
                feature.getExtensions().remove((Object)ext);
            }
        } else {
            if (ext == null) {
                ext = new Extension(ExtensionType.JSON, EXTENSION_NAME, ExtensionState.OPTIONAL);
                feature.getExtensions().add((Object)ext);
            }
            try {
                ext.setJSONStructure((JsonStructure)api.toJSONObject());
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
    }

    public ConfigurationApi() {
        this.setDefaults();
    }

    @Override
    void setDefaults() {
        super.setDefaults();
        this.setMode(Mode.STRICT);
    }

    @Override
    public void clear() {
        super.clear();
        this.configurations.clear();
        this.factories.clear();
        this.frameworkProperties.clear();
        this.internalConfigurations.clear();
        this.internalFactories.clear();
        this.internalFrameworkProperties.clear();
        this.setRegion(null);
        this.getFeatureToRegionCache().clear();
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            String modeVal;
            DescribableEntity cfg;
            JsonValue val;
            String typeVal = this.getString("region");
            if (typeVal != null) {
                this.setRegion(Region.valueOf(typeVal.toUpperCase()));
            }
            if ((val = this.getAttributes().remove("configurations")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    cfg = new ConfigurationDescription();
                    ((ConfigurableEntity)cfg).fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    this.getConfigurationDescriptions().put((String)innerEntry.getKey(), (ConfigurationDescription)cfg);
                }
            }
            if ((val = this.getAttributes().remove("factory-configurations")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    cfg = new FactoryConfigurationDescription();
                    ((FactoryConfigurationDescription)cfg).fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    this.getFactoryConfigurationDescriptions().put((String)innerEntry.getKey(), (FactoryConfigurationDescription)cfg);
                }
            }
            if ((val = this.getAttributes().remove("framework-properties")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    cfg = new FrameworkPropertyDescription();
                    ((PropertyDescription)cfg).fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    this.getFrameworkPropertyDescriptions().put((String)innerEntry.getKey(), (FrameworkPropertyDescription)cfg);
                }
            }
            if ((val = this.getAttributes().remove("internal-configurations")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    this.getInternalConfigurations().add(this.getString(innerVal));
                }
            }
            if ((val = this.getAttributes().remove("internal-factory-configurations")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    this.getInternalFactoryConfigurations().add(this.getString(innerVal));
                }
            }
            if ((val = this.getAttributes().remove("internal-framework-properties")) != null) {
                for (JsonValue innerVal : val.asJsonArray()) {
                    this.getInternalFrameworkProperties().add(this.getString(innerVal));
                }
            }
            if ((val = this.getAttributes().remove("region-cache")) != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    this.getFeatureToRegionCache().put(ArtifactId.parse((String)((String)innerEntry.getKey())), Region.valueOf(this.getString((JsonValue)innerEntry.getValue()).toUpperCase()));
                }
            }
            if ((modeVal = this.getString("mode")) != null) {
                this.setMode(Mode.valueOf(modeVal.toUpperCase()));
            }
        }
        catch (IllegalArgumentException | JsonException e) {
            throw new IOException(e);
        }
    }

    public Map<String, ConfigurationDescription> getConfigurationDescriptions() {
        return this.configurations;
    }

    public Map<String, FactoryConfigurationDescription> getFactoryConfigurationDescriptions() {
        return this.factories;
    }

    public Map<String, FrameworkPropertyDescription> getFrameworkPropertyDescriptions() {
        return this.frameworkProperties;
    }

    public Set<String> getInternalConfigurations() {
        return this.internalConfigurations;
    }

    public Set<String> getInternalFactoryConfigurations() {
        return this.internalFactories;
    }

    public Set<String> getInternalFrameworkProperties() {
        return this.internalFrameworkProperties;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region value) {
        this.region = value;
    }

    public Region detectRegion() {
        if (this.getRegion() != null) {
            return this.getRegion();
        }
        return Region.GLOBAL;
    }

    public Map<ArtifactId, Region> getFeatureToRegionCache() {
        return this.regionCache;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.mode = value == null ? Mode.STRICT : value;
    }

    @Override
    JsonObjectBuilder createJson() throws IOException {
        JsonArrayBuilder arrayBuilder;
        JsonObjectBuilder propBuilder;
        JsonObjectBuilder objBuilder = super.createJson();
        if (this.getRegion() != null) {
            objBuilder.add("region", this.getRegion().name());
        }
        if (!this.getConfigurationDescriptions().isEmpty()) {
            propBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, ConfigurationDescription> entry : this.getConfigurationDescriptions().entrySet()) {
                propBuilder.add(entry.getKey(), entry.getValue().createJson());
            }
            objBuilder.add("configurations", propBuilder);
        }
        if (!this.getFactoryConfigurationDescriptions().isEmpty()) {
            propBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, ConfigurableEntity> entry : this.getFactoryConfigurationDescriptions().entrySet()) {
                propBuilder.add(entry.getKey(), ((FactoryConfigurationDescription)entry.getValue()).createJson());
            }
            objBuilder.add("factory-configurations", propBuilder);
        }
        if (!this.getFrameworkPropertyDescriptions().isEmpty()) {
            propBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : this.getFrameworkPropertyDescriptions().entrySet()) {
                propBuilder.add((String)entry.getKey(), ((FrameworkPropertyDescription)entry.getValue()).createJson());
            }
            objBuilder.add("framework-properties", propBuilder);
        }
        if (!this.getInternalConfigurations().isEmpty()) {
            arrayBuilder = Json.createArrayBuilder();
            for (String string : this.getInternalConfigurations()) {
                arrayBuilder.add(string);
            }
            objBuilder.add("internal-configurations", arrayBuilder);
        }
        if (!this.getInternalFactoryConfigurations().isEmpty()) {
            arrayBuilder = Json.createArrayBuilder();
            for (String string : this.getInternalFactoryConfigurations()) {
                arrayBuilder.add(string);
            }
            objBuilder.add("internal-factory-configurations", arrayBuilder);
        }
        if (!this.getInternalFrameworkProperties().isEmpty()) {
            arrayBuilder = Json.createArrayBuilder();
            for (String string : this.getInternalFrameworkProperties()) {
                arrayBuilder.add(string);
            }
            objBuilder.add("internal-framework-properties", arrayBuilder);
        }
        if (!this.getFeatureToRegionCache().isEmpty()) {
            JsonObjectBuilder cacheBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : this.getFeatureToRegionCache().entrySet()) {
                cacheBuilder.add(((ArtifactId)entry.getKey()).toMvnId(), ((Region)((Object)entry.getValue())).name());
            }
            objBuilder.add("region-cache", cacheBuilder);
        }
        if (this.getMode() != Mode.STRICT) {
            objBuilder.add("mode", this.getMode().name());
        }
        return objBuilder;
    }
}

