/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api;

import java.util.Calendar;
import java.util.Objects;

public class DeprecationInfo {
    private final String message;
    private String since;
    private String forRemoval;

    public DeprecationInfo(String msg) {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public String getForRemoval() {
        return this.forRemoval;
    }

    public void setForRemoval(String value) {
        this.forRemoval = value;
    }

    public boolean isForRemoval() {
        return this.forRemoval != null && !"false".equalsIgnoreCase(this.forRemoval);
    }

    public Calendar getForRemovalBy() {
        String[] parts;
        if (this.forRemoval != null && (parts = this.forRemoval.split("-")).length == 3 && parts[0].length() == 4 && parts[1].length() == 2 && parts[2].length() == 2) {
            try {
                int year = Integer.parseInt(parts[0]);
                int month = Integer.parseInt(parts[1]);
                int day = Integer.parseInt(parts[2]);
                Calendar c = Calendar.getInstance();
                c.set(1, year);
                c.set(2, month - 1);
                c.set(5, day);
                return c;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.message, this.since, this.forRemoval);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeprecationInfo other = (DeprecationInfo)obj;
        return Objects.equals(this.message, other.message) && Objects.equals(this.since, other.since) && Objects.equals(this.forRemoval, other.forRemoval);
    }
}

