/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.MemoryArchive;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageExistsException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.ScopedWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.events.PackageEvent;
import org.apache.jackrabbit.vault.packaging.events.impl.PackageEventDispatcher;
import org.apache.jackrabbit.vault.packaging.impl.HollowVaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.ZipVaultPackage;
import org.apache.jackrabbit.vault.packaging.registry.DependencyReport;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.impl.DependencyReportImpl;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSInstallState;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageStatus;
import org.apache.jackrabbit.vault.packaging.registry.impl.FSRegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.InstallationScope;
import org.apache.jackrabbit.vault.util.InputStreamPump;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PackageRegistry.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class FSPackageRegistry
extends AbstractPackageRegistry {
    private static final String REPOSITORY_HOME = "repository.home";
    private static final Logger log = LoggerFactory.getLogger(FSPackageRegistry.class);
    private final String[] META_SUFFIXES = new String[]{"xml"};
    private Map<PackageId, FSInstallState> stateCache = new ConcurrentHashMap<PackageId, FSInstallState>();
    private Map<Path, PackageId> pathIdMapping = new ConcurrentHashMap<Path, PackageId>();
    private boolean packagesInitializied = false;
    @Reference
    private PackageEventDispatcher dispatcher;
    private File homeDir;
    private InstallationScope scope = InstallationScope.UNSCOPED;

    private File getHomeDir() {
        return this.homeDir;
    }

    public FSPackageRegistry(@NotNull File homeDir) throws IOException {
        this(homeDir, InstallationScope.UNSCOPED);
    }

    public FSPackageRegistry(@NotNull File homeDir, InstallationScope scope) throws IOException {
        this(homeDir, scope, null);
    }

    public FSPackageRegistry(@NotNull File homeDir, InstallationScope scope, @Nullable AbstractPackageRegistry.SecurityConfig securityConfig) throws IOException {
        super(securityConfig);
        this.homeDir = homeDir;
        log.info("Jackrabbit Filevault FS Package Registry initialized with home location {}", (Object)this.homeDir.getPath());
        this.scope = scope;
        this.loadPackageCache();
    }

    public FSPackageRegistry() throws IOException {
        super(null);
    }

    @Activate
    public void activate(BundleContext context, Config config) {
        File file = context.getProperty(REPOSITORY_HOME) != null ? (new File(config.homePath()).isAbsolute() ? new File(config.homePath()) : new File(context.getProperty(REPOSITORY_HOME) + "/" + config.homePath())) : (this.homeDir = context.getDataFile(config.homePath()));
        if (!this.homeDir.exists()) {
            this.homeDir.mkdirs();
        }
        log.info("Jackrabbit Filevault FS Package Registry initialized with home location {}", (Object)this.homeDir.getPath());
        this.scope = InstallationScope.valueOf(config.scope());
        this.securityConfig = new AbstractPackageRegistry.SecurityConfig(config.authIdsForHookExecution(), config.authIdsForRootInstallation());
    }

    public void setDispatcher(@Nullable PackageEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void dispatch(@NotNull PackageEvent.Type type, @NotNull PackageId id, @Nullable PackageId[] related) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.dispatch(type, id, related);
    }

    @Override
    @Nullable
    public RegisteredPackage open(@NotNull PackageId id) throws IOException {
        FSInstallState state = this.getInstallState(id);
        return FSPackageStatus.NOTREGISTERED != state.getStatus() ? new FSRegisteredPackage(this, state) : null;
    }

    @Override
    public boolean contains(@NotNull PackageId id) throws IOException {
        return this.stateCache.containsKey(id);
    }

    @Nullable
    private File getPackageFile(@NotNull PackageId id) {
        try {
            FSInstallState state = this.getInstallState(id);
            if (FSPackageStatus.NOTREGISTERED == state.getStatus()) {
                return this.buildPackageFile(id);
            }
            return state.getFilePath().toFile();
        }
        catch (IOException e) {
            log.error("Couldn't get install state of packageId {}", (Object)id, (Object)e);
            return null;
        }
    }

    private File buildPackageFile(@NotNull PackageId id) {
        String path = this.getInstallationPath(id);
        return new File(this.getHomeDir(), path + ".zip");
    }

    @NotNull
    private File getPackageMetaDataFile(@NotNull PackageId id) {
        String path = this.getInstallationPath(id);
        return new File(this.getHomeDir(), path + ".xml");
    }

    @NotNull
    protected VaultPackage openPackageFile(@NotNull PackageId id) throws IOException {
        File pkg = this.getPackageFile(id);
        if (pkg == null) {
            throw new IOException("Could not find package file for id " + id);
        }
        if (pkg.exists() && pkg.length() > 0L) {
            try {
                return new ZipVaultPackage(pkg, false, true);
            }
            catch (IOException e) {
                log.error("Cloud not open file {} as ZipVaultPackage.", (Object)pkg.getPath(), (Object)e);
                throw e;
            }
        }
        return new HollowVaultPackage(this.getInstallState(id).getProperties());
    }

    @Override
    @NotNull
    public DependencyReport analyzeDependencies(@NotNull PackageId id, boolean onlyInstalled) throws IOException, NoSuchPackageException {
        LinkedList<Dependency> unresolved = new LinkedList<Dependency>();
        LinkedList<PackageId> resolved = new LinkedList<PackageId>();
        FSInstallState state = this.getInstallState(id);
        if (FSPackageStatus.NOTREGISTERED == state.getStatus()) {
            throw new NoSuchPackageException().setId(id);
        }
        HashSet<Dependency> allDependencies = new HashSet<Dependency>();
        allDependencies.addAll(state.getDependencies());
        for (PackageId subId : state.getSubPackages().keySet()) {
            FSInstallState subState = this.getInstallState(subId);
            allDependencies.addAll(subState.getDependencies());
        }
        for (Dependency dep : allDependencies) {
            PackageId resolvedId = this.resolve(dep, onlyInstalled);
            if (resolvedId == null) {
                unresolved.add(dep);
                continue;
            }
            resolved.add(resolvedId);
        }
        return new DependencyReportImpl(id, unresolved.toArray(new Dependency[unresolved.size()]), resolved.toArray(new PackageId[resolved.size()]));
    }

    @Override
    public PackageId resolve(Dependency dependency, boolean onlyInstalled) throws IOException {
        PackageId bestId = null;
        for (PackageId id : this.packages()) {
            if (onlyInstalled && !this.isInstalled(id) || !dependency.matches(id) || bestId != null && id.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
            bestId = id;
        }
        return bestId;
    }

    boolean isInstalled(PackageId id) throws IOException {
        FSPackageStatus status = this.getInstallState(id).getStatus();
        return FSPackageStatus.EXTRACTED == status;
    }

    @Override
    @NotNull
    public PackageId register(@NotNull InputStream in, boolean replace) throws IOException, PackageExistsException {
        return this.register(in, replace, null);
    }

    @NotNull
    private PackageId register(@NotNull InputStream in, boolean replace, Dependency autoDependency) throws IOException, PackageExistsException {
        ZipVaultPackage pkg = this.upload(in, replace);
        Map<PackageId, SubPackageHandling.Option> subpackages = this.registerSubPackages(pkg, replace);
        File pkgFile = this.buildPackageFile(pkg.getId());
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        dependencies.addAll(Arrays.asList(pkg.getDependencies()));
        if (autoDependency != null) {
            dependencies.add(autoDependency);
        }
        FSInstallState state = new FSInstallState(pkg.getId(), FSPackageStatus.REGISTERED).withFilePath(pkgFile.toPath()).withDependencies(dependencies).withSubPackages(subpackages).withFilter(pkg.getArchive().getMetaInf().getFilter()).withSize(pkg.getSize()).withProperties(pkg.getArchive().getMetaInf().getProperties()).withExternal(false);
        this.setInstallState(state);
        return pkg.getId();
    }

    private Map<PackageId, SubPackageHandling.Option> registerSubPackages(VaultPackage pkg, boolean replace) throws IOException, PackageExistsException {
        HashMap<PackageId, SubPackageHandling.Option> subpackages = new HashMap<PackageId, SubPackageHandling.Option>();
        Archive.Entry packagesRoot = pkg.getArchive().getEntry("/jcr_root/etc/packages");
        if (packagesRoot != null) {
            boolean hasOwnContent = false;
            for (PathFilterSet root : pkg.getArchive().getMetaInf().getFilter().getFilterSets()) {
                if (Text.isDescendantOrEqual((String)"/etc/packages", (String)root.getRoot())) continue;
                log.debug("Package {}: contains content outside /etc/packages. Sub packages will have a dependency to it", (Object)pkg.getId());
                hasOwnContent = true;
            }
            Dependency autoDependency = hasOwnContent ? new Dependency(pkg.getId()) : null;
            this.registerSubPackages(pkg, packagesRoot, "/etc/packages", replace, subpackages, autoDependency);
            this.dispatch(PackageEvent.Type.EXTRACT_SUB_PACKAGES, pkg.getId(), subpackages.keySet().toArray(new PackageId[subpackages.size()]));
        }
        return subpackages;
    }

    private void registerSubPackages(VaultPackage vltPkg, Archive.Entry directory, String parentPath, boolean replace, Map<PackageId, SubPackageHandling.Option> subpackages, Dependency autoDependency) throws IOException, PackageExistsException {
        Collection<? extends Archive.Entry> files = directory.getChildren();
        for (Archive.Entry entry : files) {
            String fileName = entry.getName();
            String repoName = PlatformNameFormat.getRepositoryName(fileName);
            String repoPath = parentPath + "/" + repoName;
            if (entry.isDirectory()) {
                this.registerSubPackages(vltPkg, entry, repoPath, replace, subpackages, autoDependency);
                continue;
            }
            if (!repoPath.startsWith("/etc/packages/") || !repoPath.endsWith(".jar") && !repoPath.endsWith(".zip")) continue;
            try {
                InputStream in = vltPkg.getArchive().openInputStream(entry);
                try {
                    if (in == null) {
                        throw new IOException("Unable to open archive input stream of " + entry);
                    }
                    PackageId id = this.register(in, replace);
                    SubPackageHandling.Option option = vltPkg.getSubPackageHandling().getOption(id);
                    subpackages.put(id, option);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (PackageExistsException e) {
                log.info("Subpackage already registered, skipping subpackage extraction.");
            }
        }
    }

    public ZipVaultPackage upload(InputStream in, boolean replace) throws IOException, PackageExistsException {
        MemoryArchive archive = new MemoryArchive(false);
        File tempFile = File.createTempFile("upload", ".zip");
        try (InputStreamPump pump = new InputStreamPump(in, archive);){
            try {
                FileUtils.copyInputStreamToFile((InputStream)pump, (File)tempFile);
            }
            catch (Exception e) {
                String msg = "Stream could be read successfully.";
                log.error(msg);
                throw new IOException(msg, e);
            }
            if (archive.getJcrRoot() == null) {
                String msg = "Stream is not a content package. Missing 'jcr_root'.";
                log.error(msg);
                throw new IOException(msg);
            }
            MetaInf inf = archive.getMetaInf();
            PackageId pid = inf.getPackageProperties().getId();
            if (pid == null) {
                throw new IllegalArgumentException("Unable to create package. No package pid set.");
            }
            if (!pid.isValid()) {
                throw new IllegalArgumentException("Unable to create package. Illegal package name.");
            }
            File oldPkgFile = this.getPackageFile(pid);
            FSInstallState state = this.getInstallState(pid);
            if (oldPkgFile != null && oldPkgFile.exists()) {
                if (replace && !state.isExternal()) {
                    oldPkgFile.delete();
                } else {
                    throw new PackageExistsException("Package already exists: " + pid).setId(pid);
                }
            }
            ZipVaultPackage pkg = new ZipVaultPackage(archive, true);
            this.registerSubPackages(pkg, replace);
            File pkgFile = this.buildPackageFile(pid);
            FileUtils.moveFile((File)tempFile, (File)pkgFile);
            this.dispatch(PackageEvent.Type.UPLOAD, pid, null);
            ZipVaultPackage zipVaultPackage = pkg;
            return zipVaultPackage;
        }
    }

    @Override
    @NotNull
    public PackageId register(@NotNull File file, boolean replace) throws IOException, PackageExistsException {
        try (ZipVaultPackage pack = new ZipVaultPackage(file, false, true);){
            File pkgFile = this.buildPackageFile(pack.getId());
            if (pkgFile.exists()) {
                if (replace) {
                    pkgFile.delete();
                } else {
                    throw new PackageExistsException("Package already exists: " + pack.getId()).setId(pack.getId());
                }
            }
            Map<PackageId, SubPackageHandling.Option> subpackages = this.registerSubPackages(pack, replace);
            FileUtils.copyFile((File)file, (File)pkgFile);
            HashSet<Dependency> dependencies = new HashSet<Dependency>(Arrays.asList(pack.getDependencies()));
            FSInstallState state = new FSInstallState(pack.getId(), FSPackageStatus.REGISTERED).withFilePath(pkgFile.toPath()).withDependencies(dependencies).withSubPackages(subpackages).withFilter(pack.getArchive().getMetaInf().getFilter()).withSize(pack.getSize()).withProperties(pack.getArchive().getMetaInf().getProperties()).withExternal(false);
            this.setInstallState(state);
            PackageId packageId = pack.getId();
            return packageId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PackageId registerExternal(@NotNull File file, boolean replace) throws IOException, PackageExistsException {
        if (!replace && this.pathIdMapping.containsKey(file.toPath())) {
            PackageId pid = this.pathIdMapping.get(file.toPath());
            throw new PackageExistsException("Package already exists: " + pid).setId(pid);
        }
        ZipVaultPackage pack = new ZipVaultPackage(file, false, true);
        try {
            FSInstallState state = this.getInstallState(pack.getId());
            if (FSPackageStatus.NOTREGISTERED != state.getStatus()) {
                if (replace) {
                    try {
                        this.remove(pack.getId());
                    }
                    catch (NoSuchPackageException e) {
                        log.error("Status isn't NOTREGISTERD but no metafile exists to remove", (Throwable)e);
                    }
                } else {
                    throw new PackageExistsException("Package already exists: " + pack.getId()).setId(pack.getId());
                }
            }
            Map<PackageId, SubPackageHandling.Option> subpackages = this.registerSubPackages(pack, replace);
            HashSet<Dependency> dependencies = new HashSet<Dependency>(Arrays.asList(pack.getDependencies()));
            FSInstallState targetState = new FSInstallState(pack.getId(), FSPackageStatus.REGISTERED).withFilePath(file.toPath()).withDependencies(dependencies).withSubPackages(subpackages).withFilter(pack.getArchive().getMetaInf().getFilter()).withSize(pack.getSize()).withProperties(pack.getArchive().getMetaInf().getProperties()).withExternal(true);
            this.setInstallState(targetState);
            PackageId packageId = pack.getId();
            return packageId;
        }
        finally {
            if (!pack.isClosed()) {
                pack.close();
            }
        }
    }

    @Override
    public void remove(@NotNull PackageId id) throws IOException, NoSuchPackageException {
        FSInstallState state = this.getInstallState(id);
        File metaData = this.getPackageMetaDataFile(id);
        if (!metaData.exists()) {
            throw new NoSuchPackageException().setId(id);
        }
        metaData.delete();
        if (!state.isExternal()) {
            this.getPackageFile(id).delete();
        }
        this.updateInstallState(id, FSPackageStatus.NOTREGISTERED);
        this.dispatch(PackageEvent.Type.REMOVE, id, null);
    }

    @Override
    @NotNull
    public Set<PackageId> packages() throws IOException {
        return this.packagesInitializied ? this.stateCache.keySet() : this.loadPackageCache();
    }

    private Set<PackageId> loadPackageCache() throws IOException {
        HashMap<PackageId, FSInstallState> cacheEntries = new HashMap<PackageId, FSInstallState>();
        HashMap<Path, PackageId> idMapping = new HashMap<Path, PackageId>();
        Collection files = FileUtils.listFiles((File)this.getHomeDir(), (String[])this.META_SUFFIXES, (boolean)true);
        for (File file : files) {
            PackageId id;
            FSInstallState state = FSInstallState.fromFile(file);
            if (state == null || (id = state.getPackageId()) == null) continue;
            cacheEntries.put(id, state);
            idMapping.put(state.getFilePath(), id);
        }
        this.stateCache.putAll(cacheEntries);
        this.pathIdMapping.putAll(idMapping);
        this.packagesInitializied = true;
        return cacheEntries.keySet();
    }

    public String getInstallationPath(PackageId id) {
        return this.getRelativeInstallationPath(id);
    }

    @Override
    public void installPackage(@NotNull Session session, @NotNull RegisteredPackage pkg, @NotNull ImportOptions opts, boolean extract) throws IOException, PackageException {
        if (!extract) {
            String msg = "Only extraction supported by FS based registry";
            log.error(msg);
            throw new PackageException(msg);
        }
        try (VaultPackage vltPkg = pkg.getPackage();){
            WorkspaceFilter filter = this.getInstallState(vltPkg.getId()).getFilter();
            switch (this.scope) {
                case APPLICATION_SCOPED: {
                    if (filter instanceof DefaultWorkspaceFilter) {
                        opts.setFilter(ScopedWorkspaceFilter.createApplicationScoped((DefaultWorkspaceFilter)filter));
                        break;
                    }
                    String msg = "Scoped only supports WorkspaceFilters extending DefaultWorkspaceFilter";
                    log.error(msg);
                    throw new PackageException(msg);
                }
                case CONTENT_SCOPED: {
                    if (filter instanceof DefaultWorkspaceFilter) {
                        opts.setFilter(ScopedWorkspaceFilter.createContentScoped((DefaultWorkspaceFilter)filter));
                        break;
                    }
                    String msg = "Scoped only supports WorkspaceFilters extending DefaultWorkspaceFilter";
                    log.error(msg);
                    throw new PackageException(msg);
                }
            }
            ((ZipVaultPackage)vltPkg).extract(session, opts, this.getSecurityConfig());
            this.dispatch(PackageEvent.Type.EXTRACT, pkg.getId(), null);
            this.updateInstallState(vltPkg.getId(), FSPackageStatus.EXTRACTED);
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void uninstallPackage(@NotNull Session session, @NotNull RegisteredPackage pkg, @NotNull ImportOptions opts) throws IOException, PackageException {
        String msg = "Uninstallation not supported by FS based registry";
        log.error(msg);
        throw new PackageException(msg);
    }

    private void updateInstallState(PackageId pid, FSPackageStatus targetStatus) throws IOException {
        FSInstallState state = this.getInstallState(pid);
        Long installTime = state.getInstallationTime();
        if (FSPackageStatus.EXTRACTED == targetStatus) {
            installTime = Calendar.getInstance().getTimeInMillis();
        }
        FSInstallState targetState = new FSInstallState(pid, targetStatus).withFilePath(state.getFilePath()).withDependencies(state.getDependencies()).withSubPackages(state.getSubPackages()).withInstallTime(installTime).withSize(state.getSize()).withProperties(state.getProperties()).withExternal(state.isExternal());
        this.setInstallState(targetState);
    }

    private void setInstallState(@NotNull FSInstallState state) throws IOException {
        PackageId pid = state.getPackageId();
        File metaData = this.getPackageMetaDataFile(pid);
        if (state.getStatus() == FSPackageStatus.NOTREGISTERED) {
            this.pathIdMapping.remove(this.stateCache.get(pid).getFilePath());
            metaData.delete();
            this.stateCache.remove(pid);
        } else {
            state.save(metaData);
            this.stateCache.put(pid, state);
            this.pathIdMapping.put(state.getFilePath(), pid);
        }
    }

    @NotNull
    public FSInstallState getInstallState(PackageId pid) throws IOException {
        if (this.stateCache.containsKey(pid)) {
            return this.stateCache.get(pid);
        }
        File metaFile = this.getPackageMetaDataFile(pid);
        FSInstallState state = FSInstallState.fromFile(metaFile);
        if (state != null) {
            this.stateCache.put(pid, state);
            this.pathIdMapping.put(state.getFilePath(), pid);
        }
        return state != null ? state : new FSInstallState(pid, FSPackageStatus.NOTREGISTERED);
    }

    @ObjectClassDefinition(name="Apache Jackrabbit FS Package Registry Service")
    static @interface Config {
        @AttributeDefinition
        public String homePath() default "packageregistry";

        @AttributeDefinition(name="Installation Scope", description="Allows to limit the installation scope of this Apache Jackrabbit FS Package Registry Service. Packages installed from this registry may be unscoped (unfiltered), application scoped (only content for /apps & /libs) or content scoped (all content despite of /libs & /apps)", options={@Option(label="Unscoped", value="UNSCOPED"), @Option(label="Application Scoped", value="APPLICATION_SCOPED"), @Option(label="Content Scoped", value="CONTENT_SCOPED")})
        public String scope() default "UNSCOPED";

        @AttributeDefinition(description="The authorizable ids which are allowed to execute hooks (in addition to 'admin', 'administrators' and 'system'")
        public String[] authIdsForHookExecution();

        @AttributeDefinition(description="The authorizable ids which are allowed to install packages with the 'requireRoot' flag (in addition to 'admin', 'administrators' and 'system'")
        public String[] authIdsForRootInstallation();
    }
}

