/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOSupplier;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.contentparser.api.ContentParser;
import org.apache.sling.contentparser.api.ParserOptions;
import org.apache.sling.contentparser.json.JSONParserOptions;
import org.apache.sling.contentparser.json.internal.JSONContentParser;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.artifacts.InputStreamArtifactWriter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.DocViewSerializerContentHandler;
import org.apache.sling.feature.cpconverter.vltpkg.DocViewSerializerContentHandlerException;
import org.apache.sling.feature.cpconverter.vltpkg.JcrNamespaceRegistry;
import org.apache.sling.feature.cpconverter.vltpkg.SingleFileArchive;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Version;

public final class BundleEntryHandler
extends AbstractRegexEntryHandler {
    private static final String NAME_GROUP_ID = "groupId";
    private static final String NAME_ARTIFACT_ID = "artifactId";
    private static final String JAR_TYPE = "jar";
    public static final String NODETYPES_BUNDLE_HEADER = "Sling-Nodetypes";
    public static final String NAMESPACES_BUNDLE_HEADER = "Sling-Namespaces";
    private static final Pattern POM_PROPERTIES_PATTERN = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.properties");
    private static final Pattern POM_XML_PATTERN = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.xml");
    private boolean enforceBundlesBelowInstallFolder;
    private ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy;

    public BundleEntryHandler() {
        super("/jcr_root/(?:apps|libs)/.+/(?<foldername>install|config)(?:\\.(?<runmode>[^/]+))?/(?:(?<startlevel>[0-9]+)/)?.+\\.jar");
    }

    void setEnforceBundlesBelowInstallFolder(boolean enforceBundlesBelowInstallFolder) {
        this.enforceBundlesBelowInstallFolder = enforceBundlesBelowInstallFolder;
    }

    void setSlingInitialContentPolicy(ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy) {
        this.slingInitialContentPolicy = slingInitialContentPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws Exception {
        int edx;
        String bundleName;
        int idx;
        String value;
        this.logger.info("Processing bundle {}...", (Object)entry.getName());
        Matcher matcher = this.getPattern().matcher(path);
        String runMode = null;
        Integer startLevel = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
        if (this.enforceBundlesBelowInstallFolder && !"install".equals(matcher.group("foldername"))) {
            throw new IllegalStateException("OSGi bundles are only considered if placed below a folder called 'install', but the bundle at '" + path + "' is placed outside!");
        }
        runMode = matcher.group("runmode");
        if (runMode != null) {
            this.logger.debug("Runmode {} was extracted from path {}", (Object)runMode, (Object)path);
        }
        if ((value = matcher.group("startlevel")) != null) {
            startLevel = Integer.parseInt(value);
            this.logger.debug("Start level {} was extracted from path {}", (Object)startLevel, (Object)path);
        }
        if ((idx = (bundleName = entry.getName()).lastIndexOf(47)) >= 0) {
            bundleName = bundleName.substring(idx + 1);
        }
        if ((edx = bundleName.lastIndexOf(46)) > 0) {
            bundleName = bundleName.substring(0, edx);
        }
        Path tmpBundleJar = Files.createTempFile(converter.getTempDirectory().toPath(), "extracted", bundleName + ".jar", new FileAttribute[0]);
        try (OutputStream output = Files.newOutputStream(tmpBundleJar, new OpenOption[0]);
             InputStream input = Objects.requireNonNull(archive.openInputStream(entry));){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        try {
            this.processBundleInputStream(tmpBundleJar, bundleName, runMode, startLevel, converter);
        }
        finally {
            Files.delete(tmpBundleJar);
        }
    }

    void processBundleInputStream(@NotNull Path originalBundleFile, @NotNull String bundleName, @Nullable String runMode, @Nullable Integer startLevel, @NotNull ContentPackage2FeatureModelConverter converter) throws Exception {
        try (JarFile jarFile = new JarFile(originalBundleFile.toFile());){
            ArtifactId id;
            block39: {
                id = this.extractArtifactId(bundleName, jarFile);
                Clause[] clauseArray = null;
                try (InputStream strippedBundleInput = this.extractSlingInitialContent(id, jarFile, converter, runMode);){
                    if (strippedBundleInput != null && this.slingInitialContentPolicy == ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.EXTRACT_AND_REMOVE) {
                        id = id.changeVersion(id.getVersion() + "-" + "cp2fm-converted");
                        Objects.requireNonNull(converter.getArtifactsDeployer()).deploy(new InputStreamArtifactWriter(strippedBundleInput), id);
                        break block39;
                    }
                    try (InputStream originalBundleInput = Files.newInputStream(originalBundleFile, new OpenOption[0]);){
                        Objects.requireNonNull(converter.getArtifactsDeployer()).deploy(new InputStreamArtifactWriter(originalBundleInput), id);
                    }
                }
                catch (Throwable object) {
                    clauseArray = object;
                    throw object;
                }
            }
            Objects.requireNonNull(converter.getFeaturesManager()).addArtifact(runMode, id, startLevel);
            String exportHeader = Objects.requireNonNull(jarFile.getManifest()).getMainAttributes().getValue("Export-Package");
            if (exportHeader != null) {
                for (Clause clause : Parser.parseHeader((String)exportHeader)) {
                    converter.getFeaturesManager().addAPIRegionExport(runMode, clause.getName());
                }
            }
        }
    }

    static Version getModifiedOsgiVersion(Version originalVersion) {
        return new Version(originalVersion.getMajor(), originalVersion.getMinor(), originalVersion.getMicro(), originalVersion.getQualifier() + "_" + "cp2fm-converted");
    }

    @Nullable
    InputStream extractSlingInitialContent(@NotNull ArtifactId bundleArtifactId, @NotNull JarFile jarFile, @NotNull ContentPackage2FeatureModelConverter converter, @Nullable String runMode) throws Exception {
        if (this.slingInitialContentPolicy == ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.KEEP) {
            return null;
        }
        Manifest manifest = Objects.requireNonNull(jarFile.getManifest());
        Iterator pathEntries = PathEntry.getContentPaths((Manifest)manifest, (long)-1L);
        if (pathEntries == null) {
            return null;
        }
        this.logger.info("Extracting Sling-Initial-Content from '{}'", (Object)bundleArtifactId);
        ArrayList<PathEntry> pathEntryList = new ArrayList<PathEntry>();
        pathEntries.forEachRemaining(pathEntryList::add);
        manifest.getMainAttributes().remove(new Attributes.Name("Sling-Initial-Content"));
        Version originalVersion = new Version(Objects.requireNonNull(manifest.getMainAttributes().getValue("Bundle-Version")));
        manifest.getMainAttributes().putValue("Bundle-Version", BundleEntryHandler.getModifiedOsgiVersion(originalVersion).toString());
        Path newBundleFile = Files.createTempFile(converter.getTempDirectory().toPath(), "newBundle", ".jar", new FileAttribute[0]);
        JcrNamespaceRegistry namespaceRegistry = this.createNamespaceRegistry(manifest, jarFile, converter.getFeaturesManager().getNamespaceUriByPrefix());
        EnumMap<PackageType, VaultPackageAssembler> packageAssemblers = new EnumMap<PackageType, VaultPackageAssembler>(PackageType.class);
        try (OutputStream fileOutput = Files.newOutputStream(newBundleFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             JarOutputStream bundleOutput = new JarOutputStream(fileOutput, manifest);){
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                if (jarEntry.isDirectory()) continue;
                InputStream input = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    if (this.extractSlingInitialContent(jarEntry, input, bundleArtifactId, pathEntryList, packageAssemblers, namespaceRegistry, converter) || jarEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    bundleOutput.putNextEntry(jarEntry);
                    IOUtils.copy((InputStream)input, (OutputStream)bundleOutput);
                    bundleOutput.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
        }
        this.finalizePackageAssembly(packageAssemblers, converter, runMode);
        return Files.newInputStream(newBundleFile, StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean extractSlingInitialContent(@NotNull JarEntry jarEntry, @NotNull InputStream bundleFileInputStream, @NotNull ArtifactId bundleArtifactId, @NotNull Collection<PathEntry> pathEntries, @NotNull Map<PackageType, VaultPackageAssembler> packageAssemblers, @NotNull JcrNamespaceRegistry nsRegistry, @NotNull ContentPackage2FeatureModelConverter converter) throws Exception {
        String entryName = jarEntry.getName();
        Optional<PathEntry> pathEntry = pathEntries.stream().filter(p -> entryName.startsWith(p.getPath())).findFirst();
        if (!pathEntry.isPresent()) {
            return false;
        }
        Map.Entry<ContentParser, ParserOptions> contentParserAndOptions = this.getContentParserForEntry(jarEntry, pathEntry.get());
        String repositoryPath = (pathEntry.get().getTarget() != null ? pathEntry.get().getTarget() : "/") + URLDecoder.decode(entryName.substring(pathEntry.get().getPath().length()), "UTF-8");
        String contentPackageEntryPath = "/jcr_root" + PlatformNameFormat.getPlatformPath((String)repositoryPath);
        Path tmpDocViewInputFile = null;
        try {
            Throwable throwable;
            if (contentParserAndOptions != null) {
                tmpDocViewInputFile = Files.createTempFile(converter.getTempDirectory().toPath(), "docview", ".xml", new FileAttribute[0]);
                try {
                    throwable = null;
                    try (OutputStream docViewOutput = Files.newOutputStream(tmpDocViewInputFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                         DocViewSerializerContentHandler contentHandler2 = new DocViewSerializerContentHandler(docViewOutput, nsRegistry);){
                        contentParserAndOptions.getKey().parse((ContentHandler)contentHandler2, bundleFileInputStream, contentParserAndOptions.getValue());
                        contentPackageEntryPath = FilenameUtils.removeExtension((String)contentPackageEntryPath) + ".xml";
                    }
                    catch (Throwable contentHandler2) {
                        throwable = contentHandler2;
                        throw contentHandler2;
                    }
                }
                catch (IOException e) {
                    throw new IOException("Can not parse " + jarEntry, e);
                }
                catch (DocViewSerializerContentHandlerException e) {
                    throw new IOException("Can not convert " + jarEntry + " to enhanced DocView format", e);
                }
            }
            if (nsRegistry.getRegisteredCndSystemIds().contains(jarEntry.getName())) {
                contentPackageEntryPath = "/META-INF/vault/" + Text.getName((String)jarEntry.getName()) + ".cnd";
            }
            throwable = null;
            try (SingleFileArchive virtualArchive = SingleFileArchive.fromPathOrInputStream(tmpDocViewInputFile, bundleFileInputStream, (IOSupplier<Path>)((IOSupplier)() -> Files.createTempFile(converter.getTempDirectory().toPath(), "initial-content", Text.getName((String)jarEntry.getName()), new FileAttribute[0])), contentPackageEntryPath);){
                if (!converter.process(contentPackageEntryPath, virtualArchive, null, false)) {
                    VaultPackageAssembler packageAssembler = this.initPackageAssemblerForPath(bundleArtifactId, repositoryPath, pathEntry.get(), packageAssemblers, converter);
                    if (tmpDocViewInputFile != null) {
                        packageAssembler.addEntry(contentPackageEntryPath, tmpDocViewInputFile.toFile());
                    } else {
                        packageAssembler.addEntry(contentPackageEntryPath, bundleFileInputStream);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            if (tmpDocViewInputFile == null) return true;
        }
        catch (Throwable throwable) {
            if (tmpDocViewInputFile == null) throw throwable;
            Files.delete(tmpDocViewInputFile);
            throw throwable;
        }
        Files.delete(tmpDocViewInputFile);
        return true;
    }

    JcrNamespaceRegistry createNamespaceRegistry(@NotNull Manifest manifest, @NotNull JarFile jarFile, @NotNull Map<String, String> predefinedNamespaceUriByPrefix) throws RepositoryException, IOException, ParseException {
        String typesHeader;
        JcrNamespaceRegistry registry = new JcrNamespaceRegistry();
        for (Map.Entry<String, String> entry : predefinedNamespaceUriByPrefix.entrySet()) {
            registry.registerNamespace(entry.getKey(), entry.getValue());
        }
        String namespacesDefinitionHeader = manifest.getMainAttributes().getValue(NAMESPACES_BUNDLE_HEADER);
        if (namespacesDefinitionHeader != null) {
            StringTokenizer st = new StringTokenizer(namespacesDefinitionHeader, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int pos = token.indexOf(61);
                if (pos == -1) {
                    this.logger.warn("createNamespaceRegistry: Bundle {} has an invalid namespace manifest header entry: {}", (Object)manifest.getMainAttributes().getValue("Bundle-SymbolicName"), (Object)token);
                    continue;
                }
                String prefix = token.substring(0, pos).trim();
                String namespace = token.substring(pos + 1).trim();
                registry.registerNamespace(prefix, namespace);
            }
        }
        if ((typesHeader = manifest.getMainAttributes().getValue(NODETYPES_BUNDLE_HEADER)) != null) {
            for (ManifestHeader.Entry entry : ManifestHeader.parse((String)typesHeader).getEntries()) {
                JarEntry jarEntry = jarFile.getJarEntry(entry.getValue());
                if (jarEntry == null) {
                    this.logger.warn("createNamespaceRegistry: Bundle {} has referenced a non existing node type definition: {}", (Object)manifest.getMainAttributes().getValue("Bundle-SymbolicName"), (Object)entry.getValue());
                    continue;
                }
                try (InputStream inputStream = jarFile.getInputStream(jarEntry);
                     InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                    registry.registerCnd(reader, entry.getValue());
                }
            }
        }
        return registry;
    }

    public VaultPackageAssembler initPackageAssemblerForPath(@NotNull ArtifactId bundleArtifactId, @NotNull String repositoryPath, @NotNull PathEntry pathEntry, @NotNull Map<PackageType, VaultPackageAssembler> cache, @NotNull ContentPackage2FeatureModelConverter converter) {
        DefaultWorkspaceFilter filter;
        PackageType packageType = VaultPackageUtils.detectPackageType(repositoryPath);
        VaultPackageAssembler assembler = cache.get(packageType);
        if (assembler == null) {
            String packageNameSuffix;
            switch (packageType) {
                case APPLICATION: {
                    packageNameSuffix = "-apps";
                    break;
                }
                case CONTENT: {
                    packageNameSuffix = "-content";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected package type " + packageType + " detected for path " + repositoryPath);
                }
            }
            PackageId packageId = new PackageId(bundleArtifactId.getGroupId(), bundleArtifactId.getArtifactId() + packageNameSuffix, bundleArtifactId.getVersion());
            assembler = VaultPackageAssembler.create(converter.getTempDirectory(), packageId, "Generated out of Sling Initial Content from bundle " + bundleArtifactId + " by cp2fm");
            cache.put(packageType, assembler);
            this.logger.info("Created package {} out of Sling-Initial-Content from '{}'", (Object)packageId, (Object)bundleArtifactId);
        }
        if (!(filter = assembler.getFilter()).covers(repositoryPath)) {
            PathFilterSet pathFilterSet = new PathFilterSet(pathEntry.getTarget() != null ? pathEntry.getTarget() : "/");
            ImportMode importMode = pathEntry.isOverwrite() ? ImportMode.REPLACE : ImportMode.MERGE;
            pathFilterSet.setImportMode(importMode);
            filter.add(pathFilterSet);
        }
        return assembler;
    }

    void finalizePackageAssembly(@NotNull Map<PackageType, VaultPackageAssembler> packageAssemblers, @NotNull ContentPackage2FeatureModelConverter converter, @Nullable String runMode) throws Exception {
        for (Map.Entry<PackageType, VaultPackageAssembler> entry : packageAssemblers.entrySet()) {
            File packageFile = entry.getValue().createPackage(false);
            converter.processContentPackageArchive(packageFile, entry.getValue(), runMode);
        }
    }

    Map.Entry<ContentParser, ParserOptions> getContentParserForEntry(JarEntry entry, PathEntry pathEntry) {
        if (entry.getName().endsWith(".json") && !pathEntry.isIgnoredImportProvider("json")) {
            return new AbstractMap.SimpleEntry<JSONContentParser, JSONParserOptions>(new JSONContentParser(), new JSONParserOptions().withFeatures(JSONParserOptions.DEFAULT_JSON_PARSER_FEATURES));
        }
        return null;
    }

    @NotNull
    protected ArtifactId extractArtifactId(@NotNull String bundleName, @NotNull JarFile jarFile) throws IOException {
        String artifactId = null;
        String version = null;
        String groupId = null;
        String classifier = null;
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            String suffix;
            String synthesized;
            JarEntry jarEntry = e.nextElement();
            String nextEntryName = jarEntry.getName();
            if (POM_PROPERTIES_PATTERN.matcher(nextEntryName).matches()) {
                this.logger.info("Reading '{}' bundle GAV from {}...", (Object)bundleName, (Object)nextEntryName);
                Properties properties = new Properties();
                try (InputStream input = jarFile.getInputStream(jarEntry);){
                    properties.load(input);
                }
                groupId = properties.getProperty(NAME_GROUP_ID);
                artifactId = properties.getProperty(NAME_ARTIFACT_ID);
                version = properties.getProperty("version");
            } else if (POM_XML_PATTERN.matcher(nextEntryName).matches()) {
                this.logger.info("Reading '{}' bundle GAV from {}...", (Object)bundleName, (Object)nextEntryName);
                String path = nextEntryName.substring(0, nextEntryName.length() - "/pom.xml".length());
                groupId = path.substring("META-INF/maven/".length(), path.lastIndexOf(47));
                artifactId = path.substring(path.lastIndexOf(47) + 1);
                if (artifactId.indexOf(45) != -1) {
                    version = artifactId.substring(artifactId.indexOf(45));
                    artifactId = artifactId.substring(0, artifactId.indexOf(45));
                } else if (bundleName.indexOf(45) != -1) {
                    try {
                        String versionString = bundleName.substring(bundleName.indexOf(45) + 1);
                        if (!Version.parseVersion((String)versionString).equals((Object)Version.emptyVersion)) {
                            version = versionString;
                        }
                    }
                    catch (IllegalArgumentException versionString) {
                        // empty catch block
                    }
                }
            }
            if (groupId == null || artifactId == null || version == null || !bundleName.startsWith(synthesized = artifactId + "-" + version) && !bundleName.equals(artifactId)) continue;
            if (synthesized.length() >= bundleName.length() || (suffix = bundleName.substring(synthesized.length())).length() <= 1 || !suffix.startsWith("-")) break;
            classifier = suffix.substring(1);
            this.logger.info("Inferred classifier of '{}:{}:{}' to be '{}'", new Object[]{groupId, artifactId, version, classifier});
            break;
        }
        if (groupId == null) {
            groupId = BundleEntryHandler.getCheckedProperty(jarFile.getManifest(), "Bundle-SymbolicName");
            if ((groupId = groupId.replace(' ', '_').replace(':', '_').replace('/', '_').replace('\\', '_')).indexOf(46) != -1) {
                artifactId = groupId.substring(groupId.lastIndexOf(46) + 1);
                groupId = groupId.substring(0, groupId.lastIndexOf(46));
            }
            if (artifactId == null || artifactId.isEmpty()) {
                artifactId = groupId;
            }
            Version osgiVersion = Version.parseVersion((String)BundleEntryHandler.getCheckedProperty(jarFile.getManifest(), "Bundle-Version"));
            version = osgiVersion.getMajor() + "." + osgiVersion.getMinor() + "." + osgiVersion.getMicro() + (osgiVersion.getQualifier().isEmpty() ? "" : "-" + osgiVersion.getQualifier());
        }
        return new ArtifactId(groupId, artifactId, version, classifier, JAR_TYPE);
    }

    @NotNull
    private static String getCheckedProperty(@NotNull Manifest manifest, @NotNull String name) {
        String property = manifest.getMainAttributes().getValue(name);
        if (property != null) {
            property = property.trim();
        }
        return Objects.requireNonNull(property, "Jar file can not be defined as a valid OSGi bundle without specifying a valid '" + name + "' property.");
    }
}

