/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.CyclicDependencyException;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.apache.sling.feature.cpconverter.artifacts.FileArtifactWriter;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.filtering.ResourceFilter;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.NodeTypesEntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.BaseVaultPackageScanner;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.RecollectorVaultPackageScanner;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentPackage2FeatureModelConverter
extends BaseVaultPackageScanner {
    public static final String ZIP_TYPE = "zip";
    public static final String PACKAGE_CLASSIFIER = "cp2fm-converted";
    private static final String DEFAULT_VERSION = "0.0.0";
    private final Map<PackageId, String> subContentPackages = new HashMap<PackageId, String>();
    private final List<VaultPackageAssembler> assemblers = new LinkedList<VaultPackageAssembler>();
    private final Map<PackageId, Set<Dependency>> mutableContentsIds = new LinkedHashMap<PackageId, Set<Dependency>>();
    private EntryHandlersManager handlersManager;
    private AclManager aclManager;
    private FeaturesManager featuresManager;
    private ResourceFilter resourceFilter;
    private ArtifactsDeployer artifactsDeployer;
    private ArtifactsDeployer unreferencedArtifactsDeployer;
    private VaultPackageAssembler mainPackageAssembler;
    private final RecollectorVaultPackageScanner recollectorVaultPackageScanner;
    private List<PackagesEventsEmitter> emitters = new ArrayList<PackagesEventsEmitter>();
    private boolean failOnMixedPackages = false;
    private PackagePolicy contentTypePackagePolicy = PackagePolicy.REFERENCE;
    private boolean removeInstallHooks = false;
    private final File tmpDirectory;
    private List<Runnable> deployTasks = new ArrayList<Runnable>();

    public ContentPackage2FeatureModelConverter() {
        this(false);
    }

    public ContentPackage2FeatureModelConverter(boolean strictValidation) {
        super(strictValidation);
        this.recollectorVaultPackageScanner = new RecollectorVaultPackageScanner(this, this.packageManager, strictValidation, this.subContentPackages);
        try {
            this.tmpDirectory = Files.createTempDirectory("cp2fm-converter", new FileAttribute[0]).toFile();
        }
        catch (IOException io) {
            throw new RuntimeException("Unable to create a temporary directory", io);
        }
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setEntryHandlersManager(@Nullable EntryHandlersManager handlersManager) {
        this.handlersManager = handlersManager;
        return this;
    }

    @Nullable
    public FeaturesManager getFeaturesManager() {
        return this.featuresManager;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setFeaturesManager(@Nullable FeaturesManager featuresManager) {
        this.featuresManager = featuresManager;
        if (featuresManager instanceof PackagesEventsEmitter) {
            this.emitters.add((PackagesEventsEmitter)((Object)featuresManager));
        }
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setResourceFilter(@Nullable ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
        return this;
    }

    @Nullable
    public ArtifactsDeployer getArtifactsDeployer() {
        return this.artifactsDeployer;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setBundlesDeployer(@Nullable ArtifactsDeployer bundlesDeployer) {
        this.artifactsDeployer = bundlesDeployer;
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setUnreferencedArtifactsDeployer(@Nullable ArtifactsDeployer unreferencedArtifactsDeployer) {
        this.unreferencedArtifactsDeployer = unreferencedArtifactsDeployer;
        return this;
    }

    @Nullable
    public AclManager getAclManager() {
        return this.aclManager;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setAclManager(@Nullable AclManager aclManager) {
        this.aclManager = aclManager;
        return this;
    }

    @Nullable
    public VaultPackageAssembler getMainPackageAssembler() {
        return this.mainPackageAssembler;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setEmitter(@Nullable PackagesEventsEmitter emitter) {
        this.emitters.add(emitter);
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setContentTypePackagePolicy(PackagePolicy contentTypePackagePolicy) {
        this.contentTypePackagePolicy = contentTypePackagePolicy;
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setFailOnMixedPackages(boolean failOnMixedPackages) {
        this.failOnMixedPackages = failOnMixedPackages;
        return this;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter setRemoveInstallHooks(boolean removeInstallHook) {
        this.removeInstallHooks = removeInstallHook;
        return this;
    }

    @NotNull
    public File getTempDirectory() {
        return this.tmpDirectory;
    }

    public void cleanup() {
        if (this.tmpDirectory.exists()) {
            this.logger.info("Cleaning up tmp directory {}", (Object)this.tmpDirectory);
            try {
                FileUtils.deleteDirectory((File)this.tmpDirectory);
            }
            catch (IOException e) {
                this.logger.error("Error Deleting {}", (Object)this.tmpDirectory);
            }
        }
    }

    public void convert(File ... contentPackages) throws Exception {
        Objects.requireNonNull(contentPackages, "Null content-package(s) can not be converted.");
        this.secondPass(this.firstPass(contentPackages));
    }

    @NotNull
    protected Collection<VaultPackage> firstPass(File ... contentPackages) throws Exception {
        LinkedHashMap<PackageId, VaultPackage> idFileMap = new LinkedHashMap<PackageId, VaultPackage>();
        ConcurrentHashMap<PackageId, VaultPackage> idPackageMapping = new ConcurrentHashMap<PackageId, VaultPackage>();
        for (File contentPackage : contentPackages) {
            Objects.requireNonNull(contentPackage, "Null content-package can not be converted.");
            if (!contentPackage.exists() || !contentPackage.isFile()) {
                throw new IllegalArgumentException("File " + contentPackage + " does not exist or it is a directory");
            }
            this.logger.info("Reading content-package '{}'...", (Object)contentPackage);
            VaultPackage pack = this.open(contentPackage);
            idPackageMapping.put(pack.getId(), pack);
            this.recollectorVaultPackageScanner.traverse(pack);
            this.logger.info("content-package '{}' successfully read!", (Object)contentPackage);
        }
        this.logger.info("Ordering input content-package(s) {}...", idPackageMapping.keySet());
        for (VaultPackage pack : idPackageMapping.values()) {
            this.orderDependencies(idFileMap, idPackageMapping, pack, new HashSet<PackageId>());
        }
        this.logger.info("New content-package(s) order: {}", idFileMap.keySet());
        return idFileMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondPass(@NotNull Collection<VaultPackage> orderedContentPackages) throws Exception {
        this.emitters.stream().forEach(e -> e.start());
        for (VaultPackage vaultPackage : orderedContentPackages) {
            try {
                this.emitters.stream().forEach(e -> e.startPackage(vaultPackage));
                this.mainPackageAssembler = VaultPackageAssembler.create(this.getTempDirectory(), vaultPackage, this.removeInstallHooks);
                this.assemblers.add(this.mainPackageAssembler);
                ArtifactId mvnPackageId = ContentPackage2FeatureModelConverter.toArtifactId(vaultPackage.getId(), vaultPackage.getFile());
                this.featuresManager.init(mvnPackageId.getGroupId(), mvnPackageId.getArtifactId(), mvnPackageId.getVersion());
                this.logger.info("Converting content-package '{}'...", (Object)vaultPackage.getId());
                this.traverse(vaultPackage);
                File contentPackageArchive = this.mainPackageAssembler.createPackage();
                this.processContentPackageArchive(contentPackageArchive, this.mainPackageAssembler, null);
                this.aclManager.addRepoinitExtension(this.assemblers, this.featuresManager);
                this.logger.info("Conversion complete!");
                this.featuresManager.serialize();
                this.emitters.stream().forEach(e -> e.endPackage());
            }
            finally {
                this.aclManager.reset();
                this.assemblers.clear();
                try {
                    vaultPackage.close();
                }
                catch (Exception exception) {}
            }
        }
        this.deployPackages();
        this.mutableContentsIds.clear();
        this.emitters.stream().forEach(e -> e.end());
    }

    private void orderDependencies(@NotNull Map<PackageId, VaultPackage> idFileMap, @NotNull Map<PackageId, VaultPackage> idPackageMapping, @NotNull VaultPackage pack, @NotNull Set<PackageId> visited) throws CyclicDependencyException {
        if (!visited.add(pack.getId())) {
            throw new CyclicDependencyException("Cyclic dependency detected, " + pack.getId() + " was previously visited already");
        }
        block0: for (Dependency dep : pack.getDependencies()) {
            for (Map.Entry<PackageId, VaultPackage> entry : idPackageMapping.entrySet()) {
                if (!dep.matches(entry.getKey())) continue;
                this.orderDependencies(idFileMap, idPackageMapping, entry.getValue(), visited);
                continue block0;
            }
        }
        idFileMap.put(pack.getId(), pack);
        idPackageMapping.remove(pack.getId());
    }

    public void processSubPackage(@NotNull String path, @Nullable String runMode, @NotNull VaultPackage vaultPackage, boolean isEmbeddedPackage) throws Exception {
        Objects.requireNonNull(path, "Impossible to process a null vault package");
        Objects.requireNonNull(vaultPackage, "Impossible to process a null vault package");
        if (!this.isSubContentPackageIncluded(path)) {
            this.logger.info("Sub content-package {} is filtered out, so it won't be processed.", (Object)path);
            return;
        }
        this.emitters.stream().forEach(e -> e.startSubPackage(path, vaultPackage));
        VaultPackageAssembler clonedPackage = VaultPackageAssembler.create(this.getTempDirectory(), vaultPackage, this.removeInstallHooks);
        VaultPackageAssembler handler = this.mainPackageAssembler;
        this.assemblers.add(handler);
        Properties parentProps = handler.getPackageProperties();
        boolean isContainerPackage = PackageType.CONTAINER.equals(parentProps.get("packageType"));
        this.mainPackageAssembler = clonedPackage;
        this.traverse(vaultPackage);
        if (isEmbeddedPackage && !isContainerPackage) {
            PackageId parentId = new PackageId((String)parentProps.get("group"), (String)parentProps.get("name"), (String)parentProps.get("version"));
            clonedPackage.addDependency(new Dependency(parentId));
        }
        File contentPackageArchive = clonedPackage.createPackage();
        this.processContentPackageArchive(contentPackageArchive, clonedPackage, runMode);
        this.mainPackageAssembler = handler;
        this.emitters.stream().forEach(e -> e.endSubPackage());
    }

    public void processContentPackageArchive(@NotNull File contentPackageArchive, @NotNull VaultPackageAssembler assembler, @Nullable String runMode) throws Exception {
        try (VaultPackage vaultPackage = this.open(contentPackageArchive);){
            PackageType packageType = VaultPackageUtils.detectPackageType(vaultPackage);
            if (PackageType.MIXED == packageType && this.failOnMixedPackages) {
                throw new IllegalStateException("Generated content-package '" + vaultPackage.getId() + "' located in file " + contentPackageArchive + " is of MIXED type");
            }
            ArtifactId mvnPackageId = ContentPackage2FeatureModelConverter.toArtifactId(vaultPackage.getId(), contentPackageArchive);
            if (PackageType.CONTENT == packageType) {
                switch (this.contentTypePackagePolicy) {
                    case DROP: {
                        this.mutableContentsIds.put(vaultPackage.getId(), VaultPackageUtils.getDependencies(vaultPackage));
                        this.logger.info("Dropping package of PackageType.CONTENT {} (content-package id: {})", (Object)mvnPackageId.getArtifactId(), (Object)vaultPackage.getId());
                        break;
                    }
                    case PUT_IN_DEDICATED_FOLDER: {
                        this.mutableContentsIds.put(vaultPackage.getId(), VaultPackageUtils.getDependencies(vaultPackage));
                        if (this.unreferencedArtifactsDeployer == null) {
                            throw new IllegalStateException("ContentTypePackagePolicy PUT_IN_DEDICATED_FOLDER requires a valid deployer ");
                        }
                        this.unreferencedArtifactsDeployer.deploy(new FileArtifactWriter(contentPackageArchive), mvnPackageId);
                        this.logger.info("Put converted package of PackageType.CONTENT {} (content-package id: {}) in {} (not referenced in feature model)", new Object[]{mvnPackageId.getArtifactId(), vaultPackage.getId(), this.unreferencedArtifactsDeployer.getBaseDirectory()});
                        break;
                    }
                    case REFERENCE: {
                        this.deploy(assembler, mvnPackageId, runMode);
                    }
                }
            } else {
                this.deploy(assembler, mvnPackageId, runMode);
            }
        }
    }

    public void deployPackages() throws Exception {
        try {
            this.mutableContentsIds.values().forEach(value -> value.removeIf(dep -> this.mutableContentsIds.keySet().stream().anyMatch(arg_0 -> ((Dependency)dep).matches(arg_0))));
            this.deployTasks.forEach(Runnable::run);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof Exception) {
                throw ex;
            }
            throw ex;
        }
        this.deployTasks.clear();
    }

    private void deploy(VaultPackageAssembler assembler, ArtifactId mvnPackageId, String runMode) {
        this.getFeaturesManager().addArtifact(runMode, mvnPackageId);
        this.deployTasks.add(() -> {
            assembler.updateDependencies(this.mutableContentsIds);
            try {
                File finalContentPackageArchive = assembler.createPackage();
                this.getArtifactsDeployer().deploy(new FileArtifactWriter(finalContentPackageArchive), mvnPackageId);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    protected boolean isSubContentPackageIncluded(@NotNull String path) {
        return this.subContentPackages.containsValue(path);
    }

    public boolean process(@NotNull String entryPath, @NotNull Archive archive, @Nullable Archive.Entry entry, boolean useMainPackageAssembler) throws Exception {
        if (this.resourceFilter != null && this.resourceFilter.isFilteredOut(entryPath)) {
            throw new IllegalArgumentException("Path '" + entryPath + "' in archive " + archive.getMetaInf().getPackageProperties().getId() + " not allowed by user configuration, please check configured filtering patterns");
        }
        EntryHandler entryHandler = this.handlersManager.getEntryHandlerByEntryPath(entryPath);
        if (entryHandler == null) {
            if (useMainPackageAssembler) {
                entryHandler = this.mainPackageAssembler;
            } else {
                return false;
            }
        }
        if (entry == null && (entry = archive.getEntry(entryPath)) == null) {
            throw new IllegalArgumentException("Archive '" + archive.getMetaInf().getPackageProperties().getId() + "' does not contain entry with path '" + entryPath + "'");
        }
        entryHandler.handle(entryPath, archive, entry, this);
        return true;
    }

    @Override
    protected void onFile(@NotNull String entryPath, @NotNull Archive archive, @NotNull Archive.Entry entry) throws Exception {
        this.process(entryPath, archive, entry, true);
    }

    @NotNull
    public static ArtifactId toArtifactId(@NotNull PackageId packageId, @NotNull File file) {
        String groupId = Objects.requireNonNull(packageId.getGroup(), "group property not found in content-package " + file + ", please check META-INF/vault/properties.xml").replace('/', '.');
        groupId = groupId.replaceAll(" ", "_");
        String artifactid = Objects.requireNonNull(packageId.getName(), "name property not found in content-package " + file + ", please check META-INF/vault/properties.xml");
        artifactid = artifactid.replaceAll(" ", "_");
        String version = packageId.getVersionString();
        if (version.endsWith("-cp2fm-converted")) {
            version = version.substring(0, version.length() - "-cp2fm-converted".length());
        }
        if (version.isEmpty()) {
            version = DEFAULT_VERSION;
        }
        return new ArtifactId(groupId, artifactid, version, PACKAGE_CLASSIFIER, ZIP_TYPE);
    }

    @Override
    protected void addCdnPattern(@NotNull Pattern cndPattern) {
        this.handlersManager.addEntryHandler(NodeTypesEntryHandler.forCndPattern(cndPattern));
    }

    public static enum SlingInitialContentPolicy {
        KEEP,
        EXTRACT_AND_REMOVE,
        EXTRACT_AND_KEEP;

    }

    public static enum PackagePolicy {
        REFERENCE,
        DROP,
        PUT_IN_DEDICATED_FOLDER;

    }
}

