/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.repoinit.parser.operations.AclGroupBase;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SetAclPrincipals
extends AclGroupBase {
    private final List<String> principals;

    public SetAclPrincipals(List<String> principals, List<AclLine> lines) {
        this(principals, lines, new ArrayList<String>());
    }

    public SetAclPrincipals(List<String> principals, List<AclLine> lines, List<String> aclOptions) {
        super(lines, aclOptions);
        this.principals = Collections.unmodifiableList(principals);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.principals);
        sb.append(super.getParametersDescription());
        return sb.toString();
    }

    @Override
    @NotNull
    public String asRepoInitString() {
        if (this.getLines().stream().anyMatch(line -> {
            List<String> paths = line.getProperty("paths");
            return paths == null || paths.isEmpty();
        })) {
            String topline = String.format("set repository ACL for %s%s%n", SetAclPrincipals.listToString(this.principals), this.getAclOptionsString());
            return this.asRepoInit(topline, true);
        }
        String topline = String.format("set ACL for %s%s%n", SetAclPrincipals.listToString(this.principals), this.getAclOptionsString());
        return this.asRepoInit(topline, true);
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    @Override
    public void accept(OperationVisitor v) {
        v.visitSetAclPrincipal(this);
    }
}

