/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPermissionChecker {
    private static final Logger log = LoggerFactory.getLogger(AdminPermissionChecker.class);
    private static final String ADMIN_USER = "admin";
    private static final String SYSTEM_USER = "system";
    private static final String ADMINISTRATORS_GROUP = "administrators";

    public static boolean hasAdministrativePermissions(@NotNull Session session, String ... additionalAdminAuthorizableIds) throws RepositoryException {
        String userId = session.getUserID();
        if (ADMIN_USER.equals(userId) || SYSTEM_USER.equals(userId)) {
            return true;
        }
        List<String> additionalAdminIds = Arrays.asList(Optional.ofNullable(additionalAdminAuthorizableIds).orElse(new String[0]));
        if (additionalAdminIds.contains(userId)) {
            return true;
        }
        if (!(session instanceof JackrabbitSession)) {
            log.warn("could not evaluate group permissions but just user name");
            return false;
        }
        JackrabbitSession jackrabbitSession = (JackrabbitSession)session;
        Authorizable authorizable = jackrabbitSession.getUserManager().getAuthorizable(userId);
        if (authorizable == null) {
            return false;
        }
        Iterator groupIterator = authorizable.memberOf();
        while (groupIterator.hasNext()) {
            String groupId = ((Group)groupIterator.next()).getID();
            if (ADMINISTRATORS_GROUP.equals(groupId)) {
                return true;
            }
            if (!additionalAdminIds.contains(groupId)) continue;
            return true;
        }
        return false;
    }
}

