/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.io.artifacts;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.feature.io.artifacts.spi.ArtifactProviderContext;

public class ArtifactManagerConfig
implements ArtifactProviderContext {
    private String[] repositoryUrls;
    private File cacheDirectory;
    private final AtomicLong cachedArtifacts = new AtomicLong();
    private final AtomicLong downloadedArtifacts = new AtomicLong();
    private final AtomicLong localArtifacts = new AtomicLong();
    private boolean useMvn = false;
    private final String repoHome;

    public ArtifactManagerConfig() {
        this.repositoryUrls = new String[]{"file://" + new File(System.getProperty("user.home")).toURI().getPath() + ".m2/repository", "https://repo.maven.apache.org/maven2", "https://repository.apache.org/content/groups/snapshots"};
        try {
            this.cacheDirectory = Files.createTempDirectory("slingfeature", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.repoHome = System.getProperty("user.home") + "/.m2/repository/";
    }

    public void setRepositoryUrls(String[] urls) {
        if (urls == null || urls.length == 0) {
            this.repositoryUrls = null;
        } else {
            this.repositoryUrls = new String[urls.length];
            System.arraycopy(urls, 0, this.repositoryUrls, 0, urls.length);
            for (int i = 0; i < this.repositoryUrls.length; ++i) {
                if (!this.repositoryUrls[i].endsWith("/")) continue;
                this.repositoryUrls[i] = this.repositoryUrls[i].substring(0, this.repositoryUrls[i].length() - 1);
            }
        }
    }

    public String[] getRepositoryUrls() {
        return this.repositoryUrls;
    }

    @Override
    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File dir) {
        this.cacheDirectory = dir;
    }

    @Override
    public void incCachedArtifacts() {
        this.cachedArtifacts.incrementAndGet();
    }

    @Override
    public void incDownloadedArtifacts() {
        this.downloadedArtifacts.incrementAndGet();
    }

    @Override
    public void incLocalArtifacts() {
        this.localArtifacts.incrementAndGet();
    }

    public long getCachedArtifacts() {
        return this.cachedArtifacts.get();
    }

    public long getDownloadedArtifacts() {
        return this.downloadedArtifacts.get();
    }

    public long getLocalArtifacts() {
        return this.localArtifacts.get();
    }

    public boolean isUseMvn() {
        return this.useMvn;
    }

    public void setUseMvn(boolean useMvn) {
        this.useMvn = useMvn;
    }

    String getMvnHome() {
        return this.repoHome;
    }
}

