/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.extension.apiregions.api.Deprecation;
import org.apache.sling.feature.extension.apiregions.api.DeprecationInfo;

public class ApiExport
implements Comparable<ApiExport> {
    private static final String DEPRECATED_KEY = "deprecated";
    private static final String MSG_KEY = "msg";
    private static final String SINCE_KEY = "since";
    private static final String MEMBERS_KEY = "members";
    private final String name;
    private String toggle;
    private ArtifactId previous;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Deprecation deprecation = new Deprecation();

    public ApiExport(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getToggle() {
        return this.toggle;
    }

    public void setToggle(String toggle) {
        this.toggle = toggle;
    }

    public ArtifactId getPrevious() {
        return this.previous;
    }

    public void setPrevious(ArtifactId previous) {
        this.previous = previous;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Deprecation getDeprecation() {
        return this.deprecation;
    }

    void parseDeprecation(JsonValue dValue) throws IOException {
        if (dValue.getValueType() == JsonValue.ValueType.STRING) {
            DeprecationInfo info = new DeprecationInfo(((JsonString)dValue).getString());
            this.getDeprecation().setPackageInfo(info);
        } else if (dValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject depObj = dValue.asJsonObject();
            if (depObj.containsKey((Object)MSG_KEY) && depObj.containsKey((Object)MEMBERS_KEY)) {
                throw new IOException("Export " + this.getName() + " has wrong info in " + DEPRECATED_KEY);
            }
            if (!depObj.containsKey((Object)MSG_KEY) && !depObj.containsKey((Object)MEMBERS_KEY)) {
                throw new IOException("Export " + this.getName() + " has missing info in " + DEPRECATED_KEY);
            }
            if (depObj.containsKey((Object)MSG_KEY)) {
                DeprecationInfo info = new DeprecationInfo(depObj.getString(MSG_KEY));
                info.setSince(depObj.getString(SINCE_KEY, null));
                this.getDeprecation().setPackageInfo(info);
            } else {
                if (depObj.containsKey((Object)SINCE_KEY)) {
                    throw new IOException("Export " + this.getName() + " has wrong since in " + DEPRECATED_KEY);
                }
                JsonValue val = (JsonValue)depObj.get((Object)MEMBERS_KEY);
                if (val.getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IOException("Export " + this.getName() + " has wrong type for " + MEMBERS_KEY + " : " + val.getValueType().name());
                }
                for (Map.Entry memberProp : val.asJsonObject().entrySet()) {
                    if (((JsonValue)memberProp.getValue()).getValueType() == JsonValue.ValueType.STRING) {
                        DeprecationInfo info = new DeprecationInfo(((JsonString)memberProp.getValue()).getString());
                        this.getDeprecation().addMemberInfo((String)memberProp.getKey(), info);
                        continue;
                    }
                    if (((JsonValue)memberProp.getValue()).getValueType() == JsonValue.ValueType.OBJECT) {
                        JsonObject memberObj = ((JsonValue)memberProp.getValue()).asJsonObject();
                        if (!memberObj.containsKey((Object)MSG_KEY)) {
                            throw new IOException("Export " + this.getName() + " has wrong type for member in " + MEMBERS_KEY + " : " + ((JsonValue)memberProp.getValue()).getValueType().name());
                        }
                        DeprecationInfo info = new DeprecationInfo(memberObj.getString(MSG_KEY));
                        info.setSince(memberObj.getString(SINCE_KEY, null));
                        this.getDeprecation().addMemberInfo((String)memberProp.getKey(), info);
                        continue;
                    }
                    throw new IOException("Export " + this.getName() + " has wrong type for member in " + MEMBERS_KEY + " : " + ((JsonValue)memberProp.getValue()).getValueType().name());
                }
            }
        } else {
            throw new IOException("Export " + this.getName() + " has wrong type for " + DEPRECATED_KEY + " : " + dValue.getValueType().name());
        }
    }

    JsonValue deprecationToJSON() {
        Deprecation dep = this.getDeprecation();
        if (dep.getPackageInfo() != null) {
            if (dep.getPackageInfo().getSince() == null) {
                return Json.createValue((String)dep.getPackageInfo().getMessage());
            }
            JsonObjectBuilder depBuilder = Json.createObjectBuilder();
            depBuilder.add(MSG_KEY, dep.getPackageInfo().getMessage());
            depBuilder.add(SINCE_KEY, dep.getPackageInfo().getSince());
            return depBuilder.build();
        }
        if (!dep.getMemberInfos().isEmpty()) {
            JsonObjectBuilder depBuilder = Json.createObjectBuilder();
            JsonObjectBuilder membersBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, DeprecationInfo> memberEntry : dep.getMemberInfos().entrySet()) {
                if (memberEntry.getValue().getSince() == null) {
                    membersBuilder.add(memberEntry.getKey(), memberEntry.getValue().getMessage());
                    continue;
                }
                JsonObjectBuilder mBuilder = Json.createObjectBuilder();
                mBuilder.add(MSG_KEY, memberEntry.getValue().getMessage());
                mBuilder.add(SINCE_KEY, memberEntry.getValue().getSince());
                membersBuilder.add(memberEntry.getKey(), mBuilder);
            }
            depBuilder.add(MEMBERS_KEY, membersBuilder);
            return depBuilder.build();
        }
        return null;
    }

    @Override
    public int compareTo(ApiExport o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "ApiExport [name=" + this.name + ", toggle=" + this.toggle + ", previous=" + this.previous + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        return Objects.hash(this.deprecation, this.name, this.previous, this.properties, this.toggle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiExport other = (ApiExport)obj;
        return Objects.equals(this.deprecation, other.deprecation) && Objects.equals(this.name, other.name) && Objects.equals(this.previous, other.previous) && Objects.equals(this.properties, other.properties) && Objects.equals(this.toggle, other.toggle);
    }
}

