/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.InputStream;
import java.util.regex.Matcher;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.AbstractUserParser;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;

abstract class AbstractUserEntryHandler
extends AbstractRegexEntryHandler {
    AbstractUserEntryHandler(@NotNull String rexex) {
        super(rexex);
    }

    @Override
    public void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws Exception {
        Matcher matcher = this.getPattern().matcher(path);
        if (matcher.matches()) {
            path = matcher.group(1);
            RepoPath originalPath = new RepoPath(PlatformNameFormat.getRepositoryPath((String)path));
            RepoPath intermediatePath = originalPath.getParent();
            AbstractUserParser parser = this.createParser(converter, originalPath, intermediatePath);
            try (InputStream input = archive.openInputStream(entry);){
                parser.parse(input);
            }
        }
    }

    abstract AbstractUserParser createParser(@NotNull ContentPackage2FeatureModelConverter var1, @NotNull RepoPath var2, @NotNull RepoPath var3);
}

