/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.UriTemplate;
import io.wcm.handler.media.UriTemplateType;
import io.wcm.handler.media.impl.ImageFileServlet;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaPath;
import io.wcm.handler.url.UrlHandler;
import io.wcm.sling.commons.adapter.AdaptTo;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

class DamUriTemplate
implements UriTemplate {
    private final String uriTemplate;
    private final UriTemplateType type;
    private final Dimension dimension;

    DamUriTemplate(@NotNull UriTemplateType type, @NotNull Dimension dimension, @NotNull DamContext damContext, @NotNull MediaArgs mediaArgs) {
        this.uriTemplate = DamUriTemplate.buildUriTemplate(type, damContext, mediaArgs);
        this.type = type;
        this.dimension = dimension;
    }

    private static String buildUriTemplate(@NotNull UriTemplateType type, @NotNull DamContext damContext, @NotNull MediaArgs mediaArgs) {
        String productionAssetUrl;
        String url = null;
        if (!mediaArgs.isDynamicMediaDisabled() && damContext.isDynamicMediaEnabled() && damContext.isDynamicMediaAsset() && (productionAssetUrl = damContext.getDynamicMediaServerUrl()) != null) {
            switch (type) {
                case CROP_CENTER: {
                    url = productionAssetUrl + DynamicMediaPath.buildImage(damContext) + "?wid=" + "{width}" + "&hei=" + "{height}" + "&fit=crop";
                    break;
                }
                case SCALE_WIDTH: {
                    url = productionAssetUrl + DynamicMediaPath.buildImage(damContext) + "?wid=" + "{width}";
                    break;
                }
                case SCALE_HEIGHT: {
                    url = productionAssetUrl + DynamicMediaPath.buildImage(damContext) + "?hei=" + "{height}";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
                }
            }
        }
        if (url == null) {
            long DUMMY_WIDTH = 999991L;
            long DUMMY_HEIGHT = 999992L;
            String mediaPath = RenditionMetadata.buildMediaPath(damContext.getAsset().getOriginal().getPath() + "." + "image_file" + "." + 999991L + "." + 999992L + "." + "file", ImageFileServlet.getImageFileName(damContext.getAsset().getName()));
            UrlHandler urlHandler = (UrlHandler)AdaptTo.notNull((Adaptable)damContext, UrlHandler.class);
            url = urlHandler.get(mediaPath).urlMode(mediaArgs.getUrlMode()).buildExternalResourceUrl((Resource)damContext.getAsset().adaptTo(Resource.class));
            switch (type) {
                case CROP_CENTER: {
                    url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"{width}");
                    url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"{height}");
                    break;
                }
                case SCALE_WIDTH: {
                    url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"{width}");
                    url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"0");
                    break;
                }
                case SCALE_HEIGHT: {
                    url = StringUtils.replace((String)url, (String)Long.toString(999991L), (String)"0");
                    url = StringUtils.replace((String)url, (String)Long.toString(999992L), (String)"{height}");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
                }
            }
        }
        return url;
    }

    @Override
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    @Override
    public UriTemplateType getType() {
        return this.type;
    }

    @Override
    public long getMaxWidth() {
        return this.dimension.getWidth();
    }

    @Override
    public long getMaxHeight() {
        return this.dimension.getHeight();
    }

    public String toString() {
        return this.uriTemplate;
    }
}

