/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractConfigurationEntryHandler
extends AbstractRegexEntryHandler {
    private boolean enforceConfigurationBelowConfigFolder;

    AbstractConfigurationEntryHandler(@NotNull String extension) {
        super("/jcr_root/(?:apps|libs)/.+/(?<foldername>config|install)(\\.(?<runmode>[^/]+))?(.*)/(?<pid>[^\\/]*)\\." + extension + "(?<dir>.dir(/\\.content\\.xml)?)?$");
    }

    void setEnforceConfigurationBelowConfigFolder(boolean enforceConfigurationBelowConfigFolder) {
        this.enforceConfigurationBelowConfigFolder = enforceConfigurationBelowConfigFolder;
    }

    @Override
    public final void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws IOException, ConverterException {
        Matcher matcher = this.getPattern().matcher(path);
        if (matcher.matches()) {
            if (matcher.group("dir") != null) {
                this.logger.info("{} is only a dir folder next to config - removing.", (Object)path);
            } else {
                Dictionary<String, Object> configurationProperties;
                String id = AbstractConfigurationEntryHandler.extractId(matcher.group("pid"));
                this.logger.info("Processing configuration '{}'.", (Object)id);
                try (InputStream input = Objects.requireNonNull(archive.openInputStream(entry));){
                    configurationProperties = this.parseConfiguration(id, input);
                }
                if (configurationProperties == null) {
                    this.logger.info("{} entry does not contain a valid OSGi configuration, treating it as a regular resource", (Object)path);
                    converter.getMainPackageAssembler().addEntry(path, archive, entry);
                    return;
                }
                if (this.enforceConfigurationBelowConfigFolder && !"config".equals(matcher.group("foldername"))) {
                    throw new ConverterException("OSGi configuration are only considered if placed below a folder called 'config', but the configuration at '" + path + "' is placed outside!");
                }
                String runMode = matcher.group("runmode");
                FeaturesManager featuresManager = Objects.requireNonNull(converter.getFeaturesManager());
                Configuration cfg = new Configuration(id);
                featuresManager.addConfiguration(runMode, cfg, path, configurationProperties);
            }
        } else {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
    }

    @NotNull
    static String extractId(String match) {
        int idx = match.lastIndexOf(47);
        String pid = idx != -1 ? match.substring(idx + 1) : match;
        idx = pid.indexOf(45);
        if (idx != -1) {
            pid = pid.substring(0, idx).concat("~").concat(pid.substring(idx + 1));
        }
        return pid;
    }

    @Nullable
    protected abstract Dictionary<String, Object> parseConfiguration(@NotNull String var1, @NotNull InputStream var2) throws IOException, ConverterException;
}

