/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.image.Layer;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.MediaFileType;
import io.wcm.sling.commons.adapter.AdaptTo;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class AssetRendition {
    private static final Logger log = LoggerFactory.getLogger(AssetRendition.class);
    private static final Pattern ASSET_THUMBNAIL_RENDITION_NAME = Pattern.compile("^" + Pattern.quote("cq5dam.thumbnail") + "\\..*$");
    private static final Pattern ASSET_WEB_RENDITION_NAME = Pattern.compile("^" + Pattern.quote("cq5dam.web") + "\\..*$");

    private AssetRendition() {
    }

    @Nullable
    public static Dimension getDimension(@NotNull Rendition rendition) {
        return AssetRendition.getDimension(rendition, false);
    }

    @Nullable
    public static Dimension getDimension(@NotNull Rendition rendition, boolean suppressLogWarningNoRenditionsMetadata) {
        boolean isOriginal = AssetRendition.isOriginal(rendition);
        String fileExtension = FilenameUtils.getExtension((String)AssetRendition.getFilename(rendition));
        Dimension dimension = null;
        if (isOriginal) {
            dimension = AssetRendition.getDimensionFromOriginal(rendition);
        }
        if (MediaFileType.isImage(fileExtension)) {
            if (dimension == null) {
                dimension = AssetRendition.getDimensionFromRenditionMetadata(rendition);
            }
            if (dimension == null) {
                dimension = AssetRendition.getDimensionFromImageBinary(rendition, suppressLogWarningNoRenditionsMetadata);
            }
        }
        return dimension;
    }

    @Nullable
    private static Dimension getDimensionFromOriginal(@NotNull Rendition rendition) {
        Asset asset = rendition.getAsset();
        long width = AssetRendition.getAssetMetadataValueAsLong(asset, "tiff:ImageWidth", "exif:PixelXDimension");
        long height = AssetRendition.getAssetMetadataValueAsLong(asset, "tiff:ImageLength", "exif:PixelYDimension");
        return AssetRendition.toDimension(width, height);
    }

    private static long getAssetMetadataValueAsLong(Asset asset, String ... propertyNames) {
        for (String propertyName : propertyNames) {
            long value = NumberUtils.toLong((String)StringUtils.defaultString((String)asset.getMetadataValueFromJcr(propertyName), (String)"0"));
            if (value <= 0L) continue;
            return value;
        }
        return 0L;
    }

    @Nullable
    private static Dimension getDimensionFromRenditionMetadata(@NotNull Rendition rendition) {
        Asset asset = rendition.getAsset();
        String metadataPath = "jcr:content/renditionsMetadata/" + rendition.getName();
        Resource metadataResource = ((Resource)AdaptTo.notNull((Adaptable)asset, Resource.class)).getChild(metadataPath);
        if (metadataResource != null) {
            ValueMap props = metadataResource.getValueMap();
            long width = (Long)props.get("imageWidth", (Object)0L);
            long height = (Long)props.get("imageHeight", (Object)0L);
            return AssetRendition.toDimension(width, height);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Dimension getDimensionFromImageBinary(@NotNull Rendition rendition, boolean suppressLogWarningNoRenditionsMetadata) {
        try (InputStream is = rendition.getStream();){
            if (is != null) {
                if (!suppressLogWarningNoRenditionsMetadata) {
                    log.warn("Unable to detect rendition metadata for {}, fallback to inefficient detection by loading image into in memory. Please check if the service user for the bundle 'io.wcm.handler.media' is configured properly.", (Object)rendition.getPath());
                }
                Layer layer = new Layer(is);
                long width = layer.getWidth();
                long height = layer.getHeight();
                Dimension dimension = AssetRendition.toDimension(width, height);
                return dimension;
            }
            log.warn("Unable to get binary stream for rendition {}", (Object)rendition.getPath());
            return null;
        }
        catch (IOException ex) {
            log.warn("Unable to read binary stream to layer for rendition {}", (Object)rendition.getPath(), (Object)ex);
        }
        return null;
    }

    @Nullable
    private static Dimension toDimension(long width, long height) {
        if (width > 0L && height > 0L) {
            return new Dimension(width, height);
        }
        return null;
    }

    public static boolean isOriginal(@NotNull Rendition rendition) {
        return StringUtils.equals((CharSequence)rendition.getName(), (CharSequence)"original");
    }

    public static boolean isThumbnailRendition(@NotNull Rendition rendition) {
        return ASSET_THUMBNAIL_RENDITION_NAME.matcher(rendition.getName()).matches();
    }

    public static boolean isWebRendition(@NotNull Rendition rendition) {
        return ASSET_WEB_RENDITION_NAME.matcher(rendition.getName()).matches();
    }

    public static String getFilename(@NotNull Rendition rendition) {
        boolean isOriginal = AssetRendition.isOriginal(rendition);
        if (isOriginal) {
            return rendition.getAsset().getName();
        }
        return rendition.getName();
    }
}

