/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultPackageUtils {
    private static final String DEPENDENCIES_DELIMITER = ",";

    private VaultPackageUtils() {
    }

    @NotNull
    public static PackageType detectPackageType(@NotNull VaultPackage vaultPackage) {
        PackageType packageType = vaultPackage.getPackageType();
        if (packageType != null) {
            return packageType;
        }
        WorkspaceFilter filter = vaultPackage.getMetaInf().getFilter();
        if (filter != null) {
            for (PathFilterSet p : filter.getFilterSets()) {
                if ("cleanup".equals(p.getType())) continue;
                String root = p.getRoot();
                @NotNull PackageType newPackageType = VaultPackageUtils.detectPackageType(root);
                if (packageType != null && packageType != newPackageType) {
                    return PackageType.MIXED;
                }
                packageType = newPackageType;
            }
        }
        return packageType != null ? packageType : PackageType.MIXED;
    }

    @NotNull
    public static PackageType detectPackageType(String path) {
        if ("/apps".equals(path) || path.startsWith("/apps/") || "/libs".equals(path) || path.startsWith("/libs/")) {
            return PackageType.APPLICATION;
        }
        return PackageType.CONTENT;
    }

    @NotNull
    public static Set<Dependency> getDependencies(@NotNull VaultPackage vaultPackage) {
        Dependency[] originalDepenencies = vaultPackage.getDependencies();
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        if (originalDepenencies != null && originalDepenencies.length > 0) {
            dependencies.addAll(Arrays.asList(originalDepenencies));
        }
        return dependencies;
    }

    public static void setDependencies(@Nullable Set<Dependency> dependencies, @NotNull Properties properties) {
        if (dependencies == null || dependencies.isEmpty()) {
            properties.remove("dependencies");
            return;
        }
        String dependenciesString = dependencies.stream().map(d -> d.toString()).collect(Collectors.joining(DEPENDENCIES_DELIMITER));
        properties.setProperty("dependencies", dependenciesString);
    }
}

