/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.artifacts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactWriter;
import org.apache.sling.feature.cpconverter.artifacts.ArtifactsDeployer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFolderArtifactsDeployer
implements ArtifactsDeployer {
    private final File artifactsDirectory;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public SimpleFolderArtifactsDeployer(@NotNull File outputDirectory) {
        this.artifactsDirectory = outputDirectory;
        if (!this.artifactsDirectory.exists()) {
            this.artifactsDirectory.mkdirs();
        }
    }

    @Override
    @NotNull
    public File getBaseDirectory() {
        return this.artifactsDirectory;
    }

    @Override
    public void deploy(@NotNull ArtifactWriter artifactWriter, @NotNull ArtifactId id) throws IOException {
        File targetFile = new File(this.artifactsDirectory, id.toMvnName());
        this.logger.info("Writing data to {}...", (Object)targetFile);
        try (FileOutputStream targetStream = new FileOutputStream(targetFile);){
            artifactWriter.write(targetStream);
        }
        this.logger.info("Data successfully written to {}.", (Object)targetFile);
    }
}

