/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import org.apache.sling.repoinit.parser.impl.WithPathOptions;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
abstract class OperationWithPathOptions
extends Operation {
    private final WithPathOptions wpopt;

    OperationWithPathOptions(WithPathOptions wpopt) {
        this.wpopt = wpopt == null ? new WithPathOptions(null, false) : wpopt;
    }

    public String getPath() {
        return this.wpopt.path;
    }

    public boolean isForcedPath() {
        return this.wpopt.forcedPath;
    }

    @NotNull
    String asRepoInitString(@NotNull String type, @NotNull String name) {
        String path = this.wpopt.path;
        if (path == null || path.isEmpty()) {
            return String.format("create %s %s%n", type, name);
        }
        String forced = this.wpopt.forcedPath ? "forced " : "";
        return String.format("create %s %s with %spath %s%n", type, name, forced, path);
    }
}

