/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.sling.feature.cpconverter.accesscontrol.AccessControlEntry;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.handlers.AbstractPolicyEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.AbstractPolicyParser;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RepPolicyEntryHandler
extends AbstractPolicyEntryHandler {
    public RepPolicyEntryHandler() {
        this("/jcr_root(.*/)_rep_policy.xml");
    }

    RepPolicyEntryHandler(@NotNull String regex) {
        super(regex);
    }

    @Override
    @NotNull
    AbstractPolicyParser createPolicyParser(@NotNull RepoPath repositoryPath, @NotNull AclManager aclManager, @NotNull TransformerHandler handler) {
        return new RepPolicyParser(repositoryPath, aclManager, handler);
    }

    static final class RepPolicyParser
    extends AbstractPolicyParser {
        private static final String REP_ACL = "rep:ACL";
        private static final String REP_GRANT_ACE = "rep:GrantACE";
        private static final String REP_DENY_ACE = "rep:DenyACE";
        private static final Map<String, Boolean> operations = new HashMap<String, Boolean>();
        private final Stack<AccessControlEntry> acls = new Stack();
        private boolean processCurrentAcl = false;

        public RepPolicyParser(RepoPath repositoryPath, AclManager aclManager, TransformerHandler handler) {
            super(REP_ACL, repositoryPath, aclManager, handler);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.onRepAclNode) {
                String primaryType = attributes.getValue("jcr:primaryType");
                if (REP_GRANT_ACE.equals(primaryType) || REP_DENY_ACE.equals(primaryType)) {
                    String principalName = attributes.getValue("rep:principalName");
                    AccessControlEntry ace = this.createEntry(operations.get(primaryType), attributes);
                    this.addRestrictions(ace, attributes);
                    this.processCurrentAcl = this.aclManager.addAcl(principalName, ace);
                    if (this.processCurrentAcl) {
                        this.acls.add(ace);
                    } else {
                        this.hasRejectedNodes = true;
                    }
                } else if ("rep:Restrictions".equals(primaryType) && !this.acls.isEmpty() && this.processCurrentAcl) {
                    AccessControlEntry ace = this.acls.peek();
                    this.acls.add(ace);
                    this.addRestrictions(ace, attributes);
                }
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
            if (!this.onRepAclNode || !this.processCurrentAcl) {
                this.handler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.onRepAclNode && this.processCurrentAcl && !this.acls.isEmpty()) {
                this.acls.pop();
            } else {
                this.processCurrentAcl = false;
                this.handler.endElement(uri, localName, qName);
            }
        }

        static {
            operations.put(REP_GRANT_ACE, true);
            operations.put(REP_DENY_ACE, false);
        }
    }
}

