/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.jetbrains.annotations.NotNull;

public class DocViewNode2 {
    @NotNull
    private final Name name;
    private final int index;
    @NotNull
    private final Map<Name, DocViewProperty2> properties;

    public DocViewNode2(@NotNull Name name, @NotNull Collection<DocViewProperty2> properties) {
        this(name, 0, properties);
    }

    public DocViewNode2(@NotNull Name name, int index, @NotNull Collection<DocViewProperty2> properties) {
        Objects.requireNonNull(name, "name must not be null");
        this.name = name;
        if (index < 0) {
            throw new IllegalArgumentException("index must be non-negative");
        }
        this.index = index;
        Objects.requireNonNull(properties, "properties must not be null");
        this.properties = properties.stream().collect(Collectors.toMap(DocViewProperty2::getName, Function.identity()));
    }

    @NotNull
    public DocViewNode2 cloneWithDifferentProperties(@NotNull Collection<DocViewProperty2> properties) {
        return new DocViewNode2(this.name, this.index, properties);
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public Name getSnsAwareName() {
        if (this.index > 0) {
            return NameFactoryImpl.getInstance().create(this.name.getNamespaceURI(), this.name.getLocalName() + "[" + this.getIndex() + "]");
        }
        return this.name;
    }

    @NotNull
    public Collection<DocViewProperty2> getProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @NotNull
    public Optional<DocViewProperty2> getProperty(Name name) {
        return Optional.ofNullable(this.properties.get(name));
    }

    public boolean hasProperty(Name name) {
        return this.properties.containsKey(name);
    }

    @NotNull
    public Collection<String> getPropertyValues(@NotNull Name name) {
        DocViewProperty2 prop = this.properties.get(name);
        return prop == null ? Collections.emptyList() : prop.getStringValues();
    }

    @NotNull
    public Optional<String> getPropertyValue(@NotNull Name name) {
        DocViewProperty2 prop = this.properties.get(name);
        if (prop == null) {
            return Optional.empty();
        }
        return prop.getStringValue();
    }

    @NotNull
    public Optional<String> getPrimaryType() {
        return this.getPropertyValue(NameConstants.JCR_PRIMARYTYPE);
    }

    @NotNull
    public Collection<String> getMixinTypes() {
        return this.getPropertyValues(NameConstants.JCR_MIXINTYPES);
    }

    @NotNull
    public Optional<String> getIdentifier() {
        return this.getPropertyValue(NameConstants.JCR_UUID);
    }

    public String toString() {
        return "DocViewNode2 [" + (this.name != null ? "name=" + this.name + ", " : "") + "index=" + this.index + ", " + (this.properties != null ? "properties=" + this.properties : "") + "]";
    }

    public int hashCode() {
        return Objects.hash(this.index, this.name, this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocViewNode2 other = (DocViewNode2)obj;
        return this.index == other.index && DocViewNode2.areNamesEqual(this.name, other.name) && Objects.equals(this.properties, other.properties);
    }

    static boolean areNamesEqual(@NotNull Name name, @NotNull Name otherName) {
        return Objects.equals(name.getLocalName(), otherName.getLocalName()) && Objects.equals(name.getNamespaceURI(), otherName.getNamespaceURI());
    }
}

