/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractContext;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.SlingInitialContentBundleEntryMetaData;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.jetbrains.annotations.NotNull;

class SlingInitialContentBundleEntryMetaDataCollector {
    private static final double THRESHOLD_RATIO = 10.0;
    private static final int BUFFER = 512;
    private static final long TOOBIG = 0x6400000L;
    private final BundleSlingInitialContentExtractContext context;
    private final String basePath;
    private final ContentPackage2FeatureModelConverter contentPackage2FeatureModelConverter;
    private final Path newBundleFile;
    private final Set<SlingInitialContentBundleEntryMetaData> collectedSlingInitialContentBundleEntries = new HashSet<SlingInitialContentBundleEntryMetaData>();
    private final AtomicLong total = new AtomicLong(0L);
    private final JarFile jarFile;

    SlingInitialContentBundleEntryMetaDataCollector(@NotNull BundleSlingInitialContentExtractContext context, @NotNull ContentPackage2FeatureModelConverter contentPackage2FeatureModelConverter, @NotNull Path newBundleFile) {
        this.context = context;
        this.basePath = contentPackage2FeatureModelConverter.getTempDirectory().getPath();
        this.contentPackage2FeatureModelConverter = contentPackage2FeatureModelConverter;
        this.newBundleFile = newBundleFile;
        this.jarFile = context.getJarFile();
    }

    @NotNull
    Set<SlingInitialContentBundleEntryMetaData> collectFromContextAndWriteTmpFiles() throws IOException {
        Manifest manifest = this.context.getManifest();
        try (OutputStream fileOutput = Files.newOutputStream(this.newBundleFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
             JarOutputStream bundleOutput = new JarOutputStream(fileOutput, manifest);){
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                if (!jarEntry.isDirectory()) {
                    this.extractFile(jarEntry, bundleOutput);
                }
                if (this.total.get() + 512L <= 0x6400000L) continue;
                throw new IllegalStateException("File being unzipped is too big.");
            }
        }
        return this.collectedSlingInitialContentBundleEntries;
    }

    private void extractFile(JarEntry jarEntry, JarOutputStream bundleOutput) throws IOException {
        byte[] data = new byte[512];
        long compressedSize = jarEntry.getCompressedSize();
        try (BufferedInputStream input = new BufferedInputStream(this.jarFile.getInputStream(jarEntry));){
            if (this.jarEntryIsSlingInitialContent(this.context, jarEntry)) {
                File targetFile = new File(this.contentPackage2FeatureModelConverter.getTempDirectory(), jarEntry.getName());
                String canonicalDestinationPath = targetFile.getCanonicalPath();
                if (!SlingInitialContentBundleEntryMetaDataCollector.checkIfPathStartsWithOrIsEqual(this.contentPackage2FeatureModelConverter.getTempDirectory().getCanonicalPath(), canonicalDestinationPath)) {
                    throw new IOException("Entry is outside of the target directory");
                }
                targetFile.getParentFile().mkdirs();
                if (!targetFile.exists() && !targetFile.createNewFile()) {
                    throw new IOException("Could not create placeholder file!");
                }
                FileOutputStream fos = new FileOutputStream(targetFile);
                this.safelyWriteOutputStream(compressedSize, data, input, fos, true);
                SlingInitialContentBundleEntryMetaData bundleEntry = this.createSlingInitialContentBundleEntry(this.context, targetFile);
                this.collectedSlingInitialContentBundleEntries.add(bundleEntry);
            } else {
                bundleOutput.putNextEntry(jarEntry);
                this.safelyWriteOutputStream(compressedSize, data, input, bundleOutput, false);
                IOUtils.copy((InputStream)input, (OutputStream)bundleOutput);
                bundleOutput.closeEntry();
            }
        }
    }

    private void safelyWriteOutputStream(long compressedSize, byte[] data, @NotNull InputStream input, @NotNull OutputStream fos, boolean shouldClose) throws IOException {
        int count;
        BufferedOutputStream dest = new BufferedOutputStream(fos, 512);
        while (this.total.get() + 512L <= 0x6400000L && (count = input.read(data, 0, 512)) != -1) {
            dest.write(data, 0, count);
            this.total.addAndGet(count);
            double compressionRatio = (double)count / (double)compressedSize;
            if (!(compressionRatio > 10.0)) continue;
            break;
        }
        dest.flush();
        if (shouldClose) {
            dest.close();
        }
    }

    private boolean jarEntryIsSlingInitialContent(@NotNull BundleSlingInitialContentExtractContext context, @NotNull JarEntry jarEntry) {
        String entryName = jarEntry.getName();
        return context.getPathEntryList().stream().anyMatch(pathEntry -> SlingInitialContentBundleEntryMetaDataCollector.checkIfPathStartsWithOrIsEqual(pathEntry.getPath(), entryName));
    }

    @NotNull
    private SlingInitialContentBundleEntryMetaData createSlingInitialContentBundleEntry(@NotNull BundleSlingInitialContentExtractContext context, @NotNull File targetFile) throws UnsupportedEncodingException {
        String entryName = StringUtils.substringAfter((String)targetFile.getPath(), (String)(this.basePath + "/"));
        PathEntry pathEntryValue = context.getPathEntryList().stream().filter(pathEntry -> SlingInitialContentBundleEntryMetaDataCollector.checkIfPathStartsWithOrIsEqual(pathEntry.getPath(), entryName)).findFirst().orElseThrow(NullPointerException::new);
        String target = pathEntryValue.getTarget();
        String repositoryPath = (target != null ? target : "/") + URLDecoder.decode(entryName.substring(pathEntryValue.getPath().length()), "UTF-8");
        return new SlingInitialContentBundleEntryMetaData(targetFile, pathEntryValue, repositoryPath);
    }

    private static boolean checkIfPathStartsWithOrIsEqual(String pathA, String pathB) {
        String fixedPath = pathA;
        if (!fixedPath.endsWith("/")) {
            fixedPath = pathA + "/";
        }
        return pathB.startsWith(fixedPath) || pathB.equals(pathA);
    }
}

