/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config.validation;

import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.Option;
import org.apache.sling.feature.extension.apiregions.api.config.PlaceholderPolicy;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyType;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;

public class PropertyValidator {
    private boolean liveValues = false;
    private static final List<String> PLACEHOLDERS = Arrays.asList("$[env:", "$[secret:", "$[prop:");

    public boolean isLiveValues() {
        return this.liveValues;
    }

    public void setLiveValues(boolean value) {
        this.liveValues = value;
    }

    public PropertyValidationResult validate(Object value, PropertyDescription desc) {
        return this.validate(value, desc, Mode.STRICT);
    }

    public PropertyValidationResult validate(Object value, PropertyDescription desc, Mode mode) {
        Context context = new Context();
        context.description = desc;
        Mode mode2 = desc.getMode() != null ? desc.getMode() : (context.validationMode = mode != null ? mode : Mode.STRICT);
        if (value == null) {
            if (desc.isRequired()) {
                this.setResult(context, desc, "No value provided");
            }
        } else {
            ArrayList<Object> values;
            if (value.getClass().isArray()) {
                values = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    values.add(Array.get(value, i));
                }
            } else if (value instanceof Collection) {
                values = new ArrayList();
                Collection c = (Collection)value;
                for (Object o : c) {
                    values.add(o);
                }
            } else {
                values = null;
                this.validateValue(context, desc, value);
            }
            if (values != null) {
                for (Object e : values) {
                    this.validateValue(context, desc, e);
                }
                this.validateList(context, desc, values);
            }
            if (desc.getDeprecated() != null) {
                PropertyValidator.setResult(context.result, null, Mode.LENIENT, desc, desc.getDeprecated());
            }
        }
        return context.result;
    }

    void setResult(Context context, DescribableEntity desc, String msg) {
        PropertyValidator.setResult(context.result, context.description.getDefaultValue(), context.validationMode, desc, msg);
    }

    static void setResult(PropertyValidationResult result, Object defaultValue, Mode validationMode, DescribableEntity desc, String msg) {
        String postfixMsg = "";
        if (desc != null && desc.getSince() != null) {
            postfixMsg = postfixMsg.concat(". Since : ").concat(desc.getSince());
        }
        if (desc != null && desc.getEnforceOn() != null) {
            postfixMsg = postfixMsg.concat(". Enforced on : ").concat(desc.getEnforceOn());
        }
        String finalMsg = msg + postfixMsg;
        if (validationMode == Mode.STRICT) {
            result.getErrors().add(finalMsg);
        } else if (validationMode == Mode.LENIENT || validationMode == Mode.DEFINITIVE) {
            result.getWarnings().add(finalMsg);
        }
        if (validationMode == Mode.DEFINITIVE || validationMode == Mode.SILENT_DEFINITIVE) {
            result.setUseDefaultValue(true);
            result.setDefaultValue(defaultValue);
        }
    }

    void validateList(Context context, DescribableEntity desc, List<Object> values) {
        boolean found;
        if (context.description.getCardinality() > 0 && values.size() > context.description.getCardinality()) {
            this.setResult(context, desc, "Array/collection contains too many elements, only " + context.description.getCardinality() + " allowed");
        }
        if (context.description.getIncludes() != null) {
            for (String inc : context.description.getIncludes()) {
                found = false;
                for (Object val : values) {
                    if (!inc.equals(val.toString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.setResult(context, desc, "Required included value " + inc + " not found");
            }
        }
        if (context.description.getExcludes() != null) {
            for (String exc : context.description.getExcludes()) {
                found = false;
                for (Object val : values) {
                    if (!exc.equals(val.toString())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                this.setResult(context, desc, "Not allowed excluded value " + exc + " found");
            }
        }
    }

    void validateValue(Context context, PropertyDescription desc, Object value) {
        if (value != null) {
            boolean hasPlaceholder = false;
            if (value instanceof String) {
                String strVal = (String)value;
                for (String p : PLACEHOLDERS) {
                    if (!strVal.contains(p)) continue;
                    hasPlaceholder = true;
                    break;
                }
            }
            if (!hasPlaceholder) {
                switch (context.description.getType()) {
                    case BOOLEAN: {
                        this.validateBoolean(context, desc, value);
                        break;
                    }
                    case BYTE: {
                        this.validateByte(context, desc, value);
                        break;
                    }
                    case CHARACTER: {
                        this.validateCharacter(context, desc, value);
                        break;
                    }
                    case DOUBLE: {
                        this.validateDouble(context, desc, value);
                        break;
                    }
                    case FLOAT: {
                        this.validateFloat(context, desc, value);
                        break;
                    }
                    case INTEGER: {
                        this.validateInteger(context, desc, value);
                        break;
                    }
                    case LONG: {
                        this.validateLong(context, desc, value);
                        break;
                    }
                    case SHORT: {
                        this.validateShort(context, desc, value);
                        break;
                    }
                    case STRING: {
                        this.validateRequired(context, desc, value);
                        break;
                    }
                    case EMAIL: {
                        this.validateEmail(context, desc, value);
                        break;
                    }
                    case PASSWORD: {
                        this.validatePassword(context, desc, value, false);
                        break;
                    }
                    case URL: {
                        this.validateURL(context, desc, value);
                        break;
                    }
                    case PATH: {
                        this.validatePath(context, desc, value);
                        break;
                    }
                    default: {
                        context.result.getErrors().add("Unable to validate value - unknown property type : " + (Object)((Object)context.description.getType()));
                    }
                }
                this.validateRegex(context, desc, context.description.getRegexPattern(), value);
                this.validateOptions(context, desc, value);
                if (context.description.getType() != PropertyType.PASSWORD) {
                    this.validatePlaceholderPolicy(context, desc, value, false);
                }
            } else {
                if (context.description.getType() == PropertyType.PASSWORD) {
                    this.validatePassword(context, desc, value, true);
                } else if (context.description.getType() == PropertyType.STRING) {
                    this.validateRegex(context, desc, context.description.getPlaceholderRegexPattern(), value);
                    if (context.description.getRegex() != null || context.description.getOptions() != null || context.description.isRequired()) {
                        context.result.markSkipped();
                    }
                } else {
                    context.result.markSkipped();
                }
                if (context.description.getType() != PropertyType.PASSWORD) {
                    this.validatePlaceholderPolicy(context, desc, value, true);
                }
            }
        } else {
            this.setResult(context, desc, "Null value provided for validation");
        }
    }

    void validateRequired(Context context, DescribableEntity desc, Object value) {
        String val;
        if (context.description.isRequired() && (val = value.toString()).isEmpty()) {
            this.setResult(context, desc, "Value is required");
        }
    }

    void validateBoolean(Context context, DescribableEntity desc, Object value) {
        if (!(value instanceof Boolean)) {
            if (value instanceof String) {
                String v = (String)value;
                if (!v.equalsIgnoreCase("true") && !v.equalsIgnoreCase("false")) {
                    this.setResult(context, desc, "Boolean value must either be true or false, but not " + value);
                }
            } else {
                this.setResult(context, desc, "Boolean value must either be of type Boolean or String : " + value);
            }
        }
    }

    void validateByte(Context context, DescribableEntity desc, Object value) {
        if (!(value instanceof Byte)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, desc, Byte.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, desc, "Value is not a valid Byte : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, desc, ((Number)value).byteValue());
            } else {
                this.setResult(context, desc, "Byte value must either be of type Byte or String : " + value);
            }
        } else {
            this.validateRange(context, desc, (Byte)value);
        }
    }

    void validateShort(Context context, DescribableEntity desc, Object value) {
        if (!(value instanceof Short)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, desc, Short.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, desc, "Value is not a valid Short : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, desc, ((Number)value).shortValue());
            } else {
                this.setResult(context, desc, "Short value must either be of type Short or String : " + value);
            }
        } else {
            this.validateRange(context, desc, (Short)value);
        }
    }

    void validateInteger(Context context, DescribableEntity desc, Object value) {
        if (!(value instanceof Integer)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, desc, Integer.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, desc, "Value is not a valid Integer : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, desc, ((Number)value).intValue());
            } else {
                this.setResult(context, desc, "Integer value must either be of type Integer or String : " + value);
            }
        } else {
            this.validateRange(context, desc, (Integer)value);
        }
    }

    void validateLong(Context context, DescribableEntity desc, Object value) {
        if (!(value instanceof Long)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, desc, Long.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, desc, "Value is not a valid Long : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, desc, ((Number)value).longValue());
            } else {
                this.setResult(context, desc, "Long value must either be of type Long or String : " + value);
            }
        } else {
            this.validateRange(context, desc, (Long)value);
        }
    }

    void validateFloat(Context context, DescribableEntity desc, Object value) {
        if (!(value instanceof Float)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, desc, Float.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, desc, "Value is not a valid Float : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, desc, Float.valueOf(((Number)value).floatValue()));
            } else {
                this.setResult(context, desc, "Float value must either be of type Float or String : " + value);
            }
        } else {
            this.validateRange(context, desc, (Float)value);
        }
    }

    void validateDouble(Context context, DescribableEntity desc, Object value) {
        if (!(value instanceof Double)) {
            if (value instanceof String) {
                String v = (String)value;
                try {
                    this.validateRange(context, desc, Double.valueOf(v));
                }
                catch (NumberFormatException nfe) {
                    this.setResult(context, desc, "Value is not a valid Double : " + value);
                }
            } else if (value instanceof Number) {
                this.validateRange(context, desc, ((Number)value).doubleValue());
            } else {
                this.setResult(context, desc, "Double value must either be of type Double or String : " + value);
            }
        } else {
            this.validateRange(context, desc, (Double)value);
        }
    }

    void validateCharacter(Context context, DescribableEntity desc, Object value) {
        if (!(value instanceof Character)) {
            if (value instanceof String) {
                String v = (String)value;
                if (v.length() > 1) {
                    this.setResult(context, desc, "Value is not a valid Character : " + value);
                }
            } else {
                this.setResult(context, desc, "Character value must either be of type Character or String : " + value);
            }
        }
    }

    void validateURL(Context context, DescribableEntity desc, Object value) {
        String val = value.toString();
        try {
            new URL(val);
        }
        catch (MalformedURLException mue) {
            this.setResult(context, desc, "Value is not a valid URL : " + val);
        }
    }

    void validateEmail(Context context, DescribableEntity desc, Object value) {
        String val = value.toString();
        if (!val.contains("@")) {
            this.setResult(context, desc, "Not a valid email address " + val);
        }
    }

    void validatePassword(Context context, DescribableEntity desc, Object value, boolean hasPlaceholder) {
        if (!this.isLiveValues() && !hasPlaceholder && context.description.getPlaceholderPolicy() != PlaceholderPolicy.DENY) {
            this.setResult(context, desc, "Value for a password must use a placeholder");
        }
    }

    void validatePath(Context context, DescribableEntity desc, Object value) {
        String val = value.toString();
        if (!val.startsWith("/")) {
            this.setResult(context, desc, "Not a valid path " + val);
        }
    }

    void validateRange(Context context, DescribableEntity desc, Number value) {
        if (context.description.getRange() != null) {
            if (context.description.getRange().getMin() != null) {
                if (value instanceof Float || value instanceof Double) {
                    double min = context.description.getRange().getMin().doubleValue();
                    if (value.doubleValue() < min) {
                        this.setResult(context, desc, "Value " + value + " is too low; should not be lower than " + context.description.getRange().getMin());
                    }
                } else {
                    long min = context.description.getRange().getMin().longValue();
                    if (value.longValue() < min) {
                        this.setResult(context, desc, "Value " + value + " is too low; should not be lower than " + context.description.getRange().getMin());
                    }
                }
            }
            if (context.description.getRange().getMax() != null) {
                if (value instanceof Float || value instanceof Double) {
                    double max = context.description.getRange().getMax().doubleValue();
                    if (value.doubleValue() > max) {
                        this.setResult(context, desc, "Value " + value + " is too high; should not be higher than " + context.description.getRange().getMax());
                    }
                } else {
                    long max = context.description.getRange().getMax().longValue();
                    if (value.longValue() > max) {
                        this.setResult(context, desc, "Value " + value + " is too high; should not be higher than " + context.description.getRange().getMax());
                    }
                }
            }
        }
    }

    void validateRegex(Context context, PropertyDescription desc, Pattern pattern, Object value) {
        if (pattern != null && !pattern.matcher(value.toString()).matches()) {
            if (desc.getType() == PropertyType.PASSWORD) {
                this.setResult(context, desc, "Value does not match regex " + pattern.pattern());
            } else {
                this.setResult(context, desc, "Value " + value + " does not match regex " + pattern.pattern());
            }
        }
    }

    void validateOptions(Context context, PropertyDescription desc, Object value) {
        if (context.description.getOptions() != null) {
            boolean found = false;
            for (Option opt : context.description.getOptions()) {
                if (!opt.getValue().equals(value.toString())) continue;
                found = true;
            }
            if (!found) {
                if (desc.getType() == PropertyType.PASSWORD) {
                    this.setResult(context, desc, "Value does not match provided options");
                } else {
                    this.setResult(context, desc, "Value " + value + " does not match provided options");
                }
            }
        }
    }

    void validatePlaceholderPolicy(Context context, DescribableEntity desc, Object value, boolean hasPlaceholder) {
        if (!this.isLiveValues()) {
            if (context.description.getPlaceholderPolicy() == PlaceholderPolicy.DENY && hasPlaceholder) {
                this.setResult(context, desc, "Placeholder in value is not allowed");
            } else if (context.description.getPlaceholderPolicy() == PlaceholderPolicy.REQUIRE && !hasPlaceholder) {
                this.setResult(context, desc, "Value must use a placeholder");
            }
        }
    }

    static final class Context {
        public final PropertyValidationResult result = new PropertyValidationResult();
        public PropertyDescription description;
        public Mode validationMode;

        Context() {
        }
    }
}

