/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.ArtifactHandler;
import org.apache.jackrabbit.vault.fs.api.ArtifactSet;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.Dumpable;
import org.apache.jackrabbit.vault.fs.api.IdConflictPolicy;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewImporter;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.DocViewParser;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;

public abstract class AbstractArtifactHandler
implements ArtifactHandler,
Dumpable {
    protected AccessControlHandling acHandling = AccessControlHandling.OVERWRITE;
    protected AccessControlHandling cugHandling = null;
    private ACLManagement aclManagement;

    public AccessControlHandling getAcHandling() {
        return this.acHandling;
    }

    public void setAcHandling(AccessControlHandling acHandling) {
        this.acHandling = acHandling;
    }

    public AccessControlHandling getCugHandling() {
        return this.cugHandling;
    }

    public void setCugHandling(AccessControlHandling cugHandling) {
        this.cugHandling = cugHandling;
    }

    public ACLManagement getAclManagement() {
        if (this.aclManagement == null) {
            this.aclManagement = ServiceProviderFactory.getProvider().getACLManagement();
        }
        return this.aclManagement;
    }

    @Override
    public ImportInfo accept(Session session, Aggregate file, ArtifactSet artifacts) throws RepositoryException, IOException {
        Node node = file.getNode();
        String name = node.getName();
        return this.accept(new ImportOptions(), file.getManager().getWorkspaceFilter(), name.length() == 0 ? node : node.getParent(), name, (ArtifactSetImpl)artifacts);
    }

    @Override
    public ImportInfo accept(Session session, Aggregate parent, String name, ArtifactSet artifacts) throws RepositoryException, IOException {
        Node node = parent.getNode();
        return this.accept(new ImportOptions(), parent.getManager().getWorkspaceFilter(), node, name, (ArtifactSetImpl)artifacts);
    }

    protected abstract ImportInfoImpl accept(@NotNull ImportOptions var1, WorkspaceFilter var2, Node var3, String var4, ArtifactSetImpl var5) throws RepositoryException, IOException;

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
    }

    protected ImportInfoImpl importDocView(InputSource source, Node parentNode, String rootNodeName, ArtifactSetImpl artifacts, WorkspaceFilter wspFilter, IdConflictPolicy idConflictPolicy) throws IOException, RepositoryException {
        DocViewImporter handler = new DocViewImporter(parentNode, rootNodeName, artifacts, wspFilter, idConflictPolicy, this.getAcHandling(), this.getCugHandling());
        try {
            String rootNodePath = parentNode.getPath();
            if (!rootNodePath.equals("/")) {
                rootNodePath = rootNodePath + "/";
            }
            rootNodePath = rootNodePath + rootNodeName;
            new DocViewParser(parentNode.getSession()).parse(rootNodePath, source, handler);
        }
        catch (DocViewParser.XmlParseException e) {
            throw new RepositoryException((Throwable)e);
        }
        return handler.getInfo();
    }
}

