/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractContentPackageHandler
extends AbstractRegexEntryHandler {
    private static final String SNAPSHOT_POSTFIX = "-SNAPSHOT";
    private final Pattern EMBEDDED_PACKAGE_PATTERN = Pattern.compile("/jcr_root/apps/.+/install(?:\\\\.([^/]+))?/.+.zip");

    public AbstractContentPackageHandler() {
        super("/jcr_root/(?:etc/packages|apps/.+/install(?:\\.([^/]+))?)/.+.zip");
    }

    @Override
    public final void handle(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry, @NotNull ContentPackage2FeatureModelConverter converter) throws IOException, ConverterException {
        this.logger.info("Processing sub-content package '{}'...", (Object)entry.getName());
        File temporaryDir = new File(converter.getTempDirectory(), "sub-content-packages");
        temporaryDir.mkdirs();
        File temporaryContentPackage = new File(temporaryDir, entry.getName());
        if (entry.getName().contains(SNAPSHOT_POSTFIX) && temporaryContentPackage.exists()) {
            this.logger.debug("SNAPSHOT content-package detected, deleting previous version on {}...", (Object)temporaryContentPackage);
            if (temporaryContentPackage.delete()) {
                this.logger.debug("Previous SNAPSHOT content-package version on {} deleted", (Object)temporaryContentPackage);
            } else {
                this.logger.warn("Impossible to delete previous SNAPSHOT content-package version on {}, please check current user permissions", (Object)temporaryContentPackage);
            }
        }
        if (!temporaryContentPackage.exists()) {
            this.logger.debug("Extracting sub-content package '{}' to {} for future analysis...", (Object)entry.getName(), (Object)temporaryContentPackage);
            try (InputStream input = archive.openInputStream(entry);
                 FileOutputStream output = new FileOutputStream(temporaryContentPackage);){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            this.logger.debug("Sub-content package '{}' successfully extracted to {} ", (Object)entry.getName(), (Object)temporaryContentPackage);
        }
        Matcher matcher = this.getPattern().matcher(path);
        String runMode = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
        runMode = matcher.group(1);
        if (runMode != null) {
            this.logger.debug("Runmode {} was extracted from path {}", (Object)runMode, (Object)path);
        }
        boolean isEmbeddedPackage = this.EMBEDDED_PACKAGE_PATTERN.matcher(path).matches();
        try (VaultPackage vaultPackage = converter.open(temporaryContentPackage);){
            this.processSubPackage(path, runMode, vaultPackage, converter, isEmbeddedPackage);
        }
        this.logger.info("Sub-content package '{}' processing is over", (Object)entry.getName());
    }

    protected abstract void processSubPackage(@NotNull String var1, @Nullable String var2, @NotNull VaultPackage var3, @NotNull ContentPackage2FeatureModelConverter var4, boolean var5) throws IOException, ConverterException;
}

