/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.repoinit;

import java.util.Formatter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.accesscontrol.EnforceInfo;
import org.apache.sling.feature.cpconverter.repoinit.NoOpVisitor;
import org.apache.sling.feature.cpconverter.repoinit.OperatorConverterException;
import org.apache.sling.repoinit.parser.impl.WithPathOptions;
import org.apache.sling.repoinit.parser.operations.CreateServiceUser;
import org.jetbrains.annotations.NotNull;

class SystemUserVisitor
extends NoOpVisitor {
    private final Formatter formatter;
    private final EnforceInfo enforceInfo;

    SystemUserVisitor(@NotNull Formatter formatter, @NotNull EnforceInfo enforceInfo) {
        this.formatter = formatter;
        this.enforceInfo = enforceInfo;
    }

    @Override
    public void visitCreateServiceUser(CreateServiceUser createServiceUser) {
        String id = createServiceUser.getUsername();
        String path = createServiceUser.getPath();
        this.enforceInfo.recordSystemUserIds(id);
        try {
            if (this.enforceInfo.enforcePrincipalBased(id)) {
                CreateServiceUser operation = new CreateServiceUser(id, new WithPathOptions(this.enforceInfo.calculateEnforcedIntermediatePath(path), true));
                this.formatter.format("%s", operation.asRepoInitString());
            } else {
                this.formatter.format("%s", createServiceUser.asRepoInitString());
            }
        }
        catch (ConverterException ce) {
            throw new OperatorConverterException(ce);
        }
    }
}

