/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.util.LinkedList;
import javax.jcr.NamespaceException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NodeNameAndType {
    private final Name name;
    private final EffectiveNodeType effectiveNodeType;

    public static NodeNameAndType createUnknownNodeNameAndType(@Nullable NodeNameAndType parent) {
        return new NodeNameAndType(parent);
    }

    private NodeNameAndType(@Nullable NodeNameAndType parent) {
        this.effectiveNodeType = null;
        this.name = null;
    }

    public NodeNameAndType(@NotNull NameResolver nameResolver, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider, @NotNull DocViewNode node) throws IllegalNameException, NamespaceException, ConstraintViolationException, NoSuchNodeTypeException {
        this(nameResolver, effectiveNodeTypeProvider, node.name, node.primary, node.mixins);
    }

    public NodeNameAndType(@NotNull NameResolver nameResolver, @NotNull EffectiveNodeTypeProvider effectiveNodeTypeProvider, @NotNull String name, @NotNull String primaryType, String ... mixinTypes) throws IllegalNameException, NamespaceException, ConstraintViolationException, NoSuchNodeTypeException {
        try {
            this.name = name.isEmpty() ? NameConstants.ROOT : nameResolver.getQName(name);
        }
        catch (NamespaceException | IllegalNameException e) {
            throw new IllegalNameException("Invalid node name " + name + ": '" + e.getMessage() + "'", e);
        }
        LinkedList<Name> types = new LinkedList<Name>();
        try {
            types.add(nameResolver.getQName(primaryType));
        }
        catch (NamespaceException | IllegalNameException e) {
            throw new IllegalNameException("Invalid primary type " + primaryType + ": '" + e.getMessage() + "'", e);
        }
        if (mixinTypes != null) {
            for (String mixin : mixinTypes) {
                try {
                    types.add(nameResolver.getQName(mixin));
                }
                catch (NamespaceException | IllegalNameException e) {
                    throw new IllegalNameException("Invalid mixin type " + mixin + ": '" + e.getMessage() + "'", e);
                }
            }
        }
        this.effectiveNodeType = effectiveNodeTypeProvider.getEffectiveNodeType(types.toArray(new Name[0]));
    }

    public boolean isUnknown() {
        return this.effectiveNodeType == null && this.name == null;
    }

    public boolean fulfillsNodeDefinition(QNodeDefinition nodeDefinition) {
        if (!nodeDefinition.getName().equals(NameConstants.ANY_NAME) && !nodeDefinition.getName().equals(this.name)) {
            return false;
        }
        for (Name requiredType : nodeDefinition.getRequiredPrimaryTypes()) {
            if (this.effectiveNodeType.includesNodeType(requiredType)) continue;
            return false;
        }
        return true;
    }

    public EffectiveNodeType getEffectiveNodeType() {
        return this.effectiveNodeType;
    }

    public String toString() {
        return "NodeNameAndType [" + (this.name != null ? "name=" + this.name + ", " : "") + (this.effectiveNodeType != null ? "effectiveNodeType=" + this.effectiveNodeType : "") + "]";
    }
}

