/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.packaging.CyclicDependencyException;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.DependencyException;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.DependencyReport;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlan;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import org.apache.jackrabbit.vault.packaging.registry.PackageTaskBuilder;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.ExecutionPlanImpl;
import org.apache.jackrabbit.vault.packaging.registry.impl.PackageTaskImpl;
import org.apache.jackrabbit.vault.util.RejectingEntityResolver;
import org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExecutionPlanBuilderImpl
implements ExecutionPlanBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExecutionPlanBuilderImpl.class);
    private static final String ATTR_VERSION = "version";
    private static final String TAG_EXECUTION_PLAN = "executionPlan";
    private static final String TAG_TASK = "task";
    private static final String ATTR_CMD = "cmd";
    private static final String ATTR_PACKAGE_ID = "packageId";
    public static final double SUPPORTED_VERSION = 1.0;
    protected double version = 1.0;
    private final List<TaskBuilder> tasks = new LinkedList<TaskBuilder>();
    private final PackageRegistry registry;
    private Session session;
    private ProgressTrackerListener listener;
    private ExecutionPlanImpl plan;
    private Set<PackageId> externalPackages = Collections.emptySet();

    ExecutionPlanBuilderImpl(PackageRegistry registry) {
        this.registry = registry;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder save(@NotNull OutputStream out) throws IOException, PackageException {
        this.validate();
        try (FormattingXmlStreamWriter writer = FormattingXmlStreamWriter.create(out, new OutputFormat(4, false));){
            writer.writeStartDocument();
            writer.writeStartElement(TAG_EXECUTION_PLAN);
            writer.writeAttribute(ATTR_VERSION, String.valueOf(this.version));
            for (PackageTask task : this.plan.getTasks()) {
                writer.writeStartElement(TAG_TASK);
                writer.writeAttribute(ATTR_CMD, task.getType().name().toLowerCase());
                writer.writeAttribute(ATTR_PACKAGE_ID, task.getPackageId().toString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder load(@NotNull InputStream in) throws IOException {
        this.tasks.clear();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RejectingEntityResolver());
            Document document = builder.parse(in);
            Element doc = document.getDocumentElement();
            if (!TAG_EXECUTION_PLAN.equals(doc.getNodeName())) {
                throw new IOException("<executionPlan> expected.");
            }
            String v = doc.getAttribute(ATTR_VERSION);
            if (v == null || "".equals(v)) {
                v = "1.0";
            }
            this.version = Double.parseDouble(v);
            if (this.version > 1.0) {
                throw new IOException("version " + this.version + " not supported.");
            }
            this.read(doc);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new IOException("Configuration file syntax error.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return this;
    }

    private void read(Element elem) throws IOException {
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            if (!TAG_TASK.equals(child.getNodeName())) {
                throw new IOException("<task> expected.");
            }
            this.readTask((Element)child);
        }
    }

    private void readTask(Element elem) throws IOException {
        PackageTask.Type type = PackageTask.Type.valueOf(elem.getAttribute(ATTR_CMD).toUpperCase());
        PackageId id = PackageId.fromString(elem.getAttribute(ATTR_PACKAGE_ID));
        this.addTask().with(id).with(type);
    }

    @Override
    @NotNull
    public PackageTaskBuilder addTask() {
        TaskBuilder task = new TaskBuilder();
        this.tasks.add(task);
        this.plan = null;
        return task;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder with(@NotNull Session session) {
        this.session = session;
        return this;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder with(@NotNull ProgressTrackerListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder validate() throws IOException, PackageException {
        HashMap<PackageId, PackageTask> installTasks = new HashMap<PackageId, PackageTask>();
        HashMap<PackageId, PackageTask> uninstallTasks = new HashMap<PackageId, PackageTask>();
        HashMap<PackageId, PackageTaskImpl> removeTasks = new HashMap<PackageId, PackageTaskImpl>();
        ArrayList<PackageTask> packageTasks = new ArrayList<PackageTask>(this.tasks.size());
        for (TaskBuilder task : this.tasks) {
            if (task.id == null || task.type == null) {
                throw new PackageException("task builder must have package id and type defined.");
            }
            if (!this.registry.contains(task.id)) {
                throw new NoSuchPackageException("No such package: " + task.id);
            }
            PackageTaskImpl pTask = new PackageTaskImpl(task.id, task.type);
            switch (task.type) {
                case INSTALL: 
                case EXTRACT: {
                    installTasks.put(task.id, pTask);
                    break;
                }
                case UNINSTALL: {
                    uninstallTasks.put(task.id, pTask);
                    break;
                }
                case REMOVE: {
                    removeTasks.put(task.id, pTask);
                }
            }
        }
        for (PackageId id : uninstallTasks.keySet().toArray(new PackageId[uninstallTasks.size()])) {
            this.resolveUninstall(id, packageTasks, uninstallTasks, new HashSet<PackageId>());
        }
        packageTasks.addAll(removeTasks.values());
        for (PackageId id : installTasks.keySet().toArray(new PackageId[installTasks.size()])) {
            this.resolveInstall(id, packageTasks, installTasks, new HashSet<PackageId>(), ((PackageTask)installTasks.get(id)).getType());
        }
        for (PackageTask task : packageTasks) {
            log.info("- {}", (Object)task);
        }
        this.plan = new ExecutionPlanImpl(packageTasks);
        return this;
    }

    private void resolveInstall(PackageId id, List<PackageTask> packageTasks, Map<PackageId, PackageTask> installTasks, Set<PackageId> resolved, PackageTask.Type type) throws IOException, PackageException {
        if (resolved.contains(id)) {
            throw new CyclicDependencyException("Package has cyclic dependencies: " + id);
        }
        resolved.add(id);
        DependencyReport report = this.registry.analyzeDependencies(id, false);
        if (report.getUnresolvedDependencies().length > 0) {
            throw new DependencyException("Package " + id + " has unresolved dependencies: " + Dependency.toString(report.getUnresolvedDependencies()));
        }
        for (PackageId depId : report.getResolvedDependencies()) {
            if (installTasks.get(depId) == PackageTaskImpl.MARKER) continue;
            try (RegisteredPackage pkg = this.registry.open(depId);){
                if (pkg == null || pkg.isInstalled()) {
                    continue;
                }
            }
            this.resolveInstall(depId, packageTasks, installTasks, resolved, type);
        }
        PackageTask task = installTasks.get(id);
        if (task == PackageTaskImpl.MARKER) {
            return;
        }
        if (!this.externalPackages.contains(id)) {
            if (task == null) {
                task = new PackageTaskImpl(id, type);
            }
            packageTasks.add(task);
        }
        installTasks.put(id, PackageTaskImpl.MARKER);
    }

    private void resolveUninstall(PackageId id, List<PackageTask> packageTasks, Map<PackageId, PackageTask> uninstallTasks, Set<PackageId> resolved) throws IOException, PackageException {
        if (resolved.contains(id)) {
            throw new CyclicDependencyException("Package has cyclic dependencies: " + id);
        }
        resolved.add(id);
        for (PackageId depId : this.registry.usage(id)) {
            if (uninstallTasks.get(depId) == PackageTaskImpl.MARKER) continue;
            try (RegisteredPackage pkg = this.registry.open(depId);){
                if (pkg == null || !pkg.isInstalled()) {
                    continue;
                }
            }
            this.resolveUninstall(depId, packageTasks, uninstallTasks, resolved);
        }
        PackageTask task = uninstallTasks.get(id);
        if (task == PackageTaskImpl.MARKER) {
            return;
        }
        if (task == null) {
            task = new PackageTaskImpl(id, PackageTask.Type.UNINSTALL);
        }
        packageTasks.add(task);
        uninstallTasks.put(id, PackageTaskImpl.MARKER);
    }

    @Override
    @NotNull
    public ExecutionPlan execute() throws IOException, PackageException {
        if (this.plan == null) {
            this.validate();
        }
        if (this.session == null) {
            for (PackageTask task : this.plan.getTasks()) {
                if (task.getType() == PackageTask.Type.REMOVE) continue;
                throw new PackageException("Session not set in builder, but " + task + " task requires it.");
            }
        }
        return this.plan.with(this.registry).with(this.session).with(this.listener).execute();
    }

    @Override
    public ExecutionPlanBuilder with(Set<PackageId> externalPackages) {
        this.externalPackages = new HashSet<PackageId>(externalPackages);
        return this;
    }

    @Override
    public Set<PackageId> preview() throws IOException, PackageException {
        this.validate();
        if (this.plan.getTasks().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<PackageId> packages = new HashSet<PackageId>();
        for (PackageTask task : this.plan.getTasks()) {
            packages.add(task.getPackageId());
        }
        return packages;
    }

    private class TaskBuilder
    implements PackageTaskBuilder {
        private PackageId id;
        private PackageTask.Type type;

        private TaskBuilder() {
        }

        @Override
        public PackageTaskBuilder with(@NotNull PackageId id) {
            this.id = id;
            return this;
        }

        @Override
        @NotNull
        public ExecutionPlanBuilder with(@NotNull PackageTask.Type type) {
            this.type = type;
            return ExecutionPlanBuilderImpl.this;
        }
    }
}

