/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageExistsException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.DependencyReport;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.DependencyReportImpl;
import org.apache.jackrabbit.vault.packaging.registry.impl.ExecutionPlanBuilderImpl;
import org.apache.jackrabbit.vault.packaging.registry.impl.InternalPackageRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPackageRegistry
implements PackageRegistry,
InternalPackageRegistry {
    public static final String DEFAULT_PACKAGE_ROOT_PATH = "/etc/packages";
    public static final String ARCHIVE_PACKAGE_ROOT_PATH = "/jcr_root/etc/packages";
    public static final String DEFAULT_PACKAGE_ROOT_PATH_PREFIX = "/etc/packages/";
    @NotNull
    protected SecurityConfig securityConfig;

    public AbstractPackageRegistry(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig != null ? securityConfig : new SecurityConfig(null, null);
    }

    @Override
    public abstract void installPackage(Session var1, RegisteredPackage var2, ImportOptions var3, boolean var4) throws IOException, PackageException;

    @Override
    public abstract void uninstallPackage(Session var1, RegisteredPackage var2, ImportOptions var3) throws IOException, PackageException;

    @Override
    public abstract boolean contains(PackageId var1) throws IOException;

    @Override
    public abstract Set<PackageId> packages() throws IOException;

    @Override
    public abstract RegisteredPackage open(PackageId var1) throws IOException;

    @Override
    public abstract PackageId register(InputStream var1, boolean var2) throws IOException, PackageExistsException;

    @Override
    public abstract PackageId register(File var1, boolean var2) throws IOException, PackageExistsException;

    @Override
    public abstract PackageId registerExternal(File var1, boolean var2) throws IOException, PackageExistsException;

    @Override
    public abstract void remove(PackageId var1) throws IOException, NoSuchPackageException;

    @Override
    @NotNull
    public DependencyReport analyzeDependencies(@NotNull PackageId id, boolean onlyInstalled) throws IOException, NoSuchPackageException {
        LinkedList<Dependency> unresolved = new LinkedList<Dependency>();
        LinkedList<PackageId> resolved = new LinkedList<PackageId>();
        try (RegisteredPackage pkg = this.open(id);){
            if (pkg == null) {
                throw new NoSuchPackageException().setId(id);
            }
            for (Dependency dep : pkg.getPackage().getDependencies()) {
                PackageId resolvedId = this.resolve(dep, onlyInstalled);
                if (resolvedId == null) {
                    unresolved.add(dep);
                    continue;
                }
                resolved.add(resolvedId);
            }
        }
        return new DependencyReportImpl(id, unresolved.toArray(new Dependency[unresolved.size()]), resolved.toArray(new PackageId[resolved.size()]));
    }

    @Override
    public abstract PackageId resolve(Dependency var1, boolean var2) throws IOException;

    @Override
    @NotNull
    public PackageId[] usage(PackageId id) throws IOException {
        TreeSet<PackageId> usages = new TreeSet<PackageId>();
        block6: for (PackageId pid : this.packages()) {
            RegisteredPackage pkg = this.open(pid);
            try {
                if (pkg == null || !pkg.isInstalled()) continue;
                for (Dependency dep : pkg.getPackage().getDependencies()) {
                    if (!dep.matches(id)) continue;
                    usages.add(pid);
                    continue block6;
                }
            }
            finally {
                if (pkg == null) continue;
                pkg.close();
            }
        }
        return usages.toArray(new PackageId[usages.size()]);
    }

    @Override
    @NotNull
    public ExecutionPlanBuilder createExecutionPlan() {
        return new ExecutionPlanBuilderImpl(this);
    }

    public String getRelativeInstallationPath(PackageId id) {
        StringBuilder b = new StringBuilder("/");
        if (id.getGroup().length() > 0) {
            b.append(id.getGroup());
            b.append("/");
        }
        b.append(id.getName());
        String v = id.getVersion().toString();
        if (v.length() > 0) {
            b.append("-").append(v);
        }
        return b.toString();
    }

    protected static PackageId createRandomPid() {
        return new PackageId("temporary", "pack_" + UUID.randomUUID().toString(), (String)null);
    }

    @NotNull
    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public static final class SecurityConfig {
        private final String[] authIdsForHookExecution;
        private final String[] authIdsForRootInstallation;

        public SecurityConfig(String[] authIdsForHooks, String[] authIdsForRoots) {
            this.authIdsForHookExecution = authIdsForHooks;
            this.authIdsForRootInstallation = authIdsForRoots;
        }

        public String[] getAuthIdsForHookExecution() {
            return this.authIdsForHookExecution;
        }

        public String[] getAuthIdsForRootInstallation() {
            return this.authIdsForRootInstallation;
        }
    }
}

