/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.io.IOException;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.AbstractArtifactHandler;
import org.apache.jackrabbit.vault.fs.impl.io.ChildNodeStash;
import org.apache.jackrabbit.vault.fs.impl.io.ImportInfoImpl;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;

public class FolderArtifactHandler
extends AbstractArtifactHandler {
    private String nodeType = "nt:folder";

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        Artifact dir = artifacts.getDirectory();
        if (dir == null || artifacts.size() != 1) {
            return null;
        }
        ImportInfoImpl info = new ImportInfoImpl();
        if (dir.getRelativePath().length() == 0) {
            return info;
        }
        if (!parent.hasNode(dir.getRelativePath())) {
            Node node = wspFilter.contains(parent.getPath() + "/" + dir.getRelativePath()) ? parent.addNode(dir.getRelativePath(), this.nodeType) : (parent.getPrimaryNodeType().canAddChildNode(dir.getRelativePath()) ? parent.addNode(dir.getRelativePath()) : parent.addNode(dir.getRelativePath(), this.nodeType));
            info.onCreated(node.getPath());
        } else {
            HashSet<String> hints = new HashSet<String>();
            String rootPath = parent.getPath();
            if (!rootPath.equals("/")) {
                rootPath = rootPath + "/";
            }
            for (Artifact a : artifacts.values(ArtifactType.HINT)) {
                hints.add(rootPath + a.getRelativePath());
            }
            Node node = parent.getNode(dir.getRelativePath());
            if (wspFilter.contains(node.getPath()) && !this.nodeType.equals(node.getPrimaryNodeType().getName())) {
                node = this.modifyPrimaryType(node, info);
            }
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                String path = child.getPath();
                if (!wspFilter.contains(path) || wspFilter.getImportMode(path) != ImportMode.REPLACE) continue;
                if (!hints.contains(path)) {
                    if (this.getAclManagement().isACLNode(child)) {
                        if (this.acHandling != AccessControlHandling.OVERWRITE && this.acHandling != AccessControlHandling.CLEAR) continue;
                        info.onDeleted(path);
                        this.getAclManagement().clearACL(node);
                        continue;
                    }
                    info.onDeleted(path);
                    child.remove();
                    continue;
                }
                if (this.acHandling != AccessControlHandling.CLEAR || !this.getAclManagement().isACLNode(child)) continue;
                info.onDeleted(path);
                this.getAclManagement().clearACL(node);
            }
        }
        return info;
    }

    private Node modifyPrimaryType(Node node, ImportInfoImpl info) throws RepositoryException {
        String name = node.getName();
        Node parent = node.getParent();
        this.ensureCheckedOut(node, info);
        ChildNodeStash recovery = new ChildNodeStash(node.getSession());
        recovery.stashChildren(node);
        node.remove();
        Node newNode = parent.addNode(name, this.nodeType);
        info.onReplaced(newNode.getPath());
        recovery.recoverChildren(newNode, info);
        return newNode;
    }

    private void ensureCheckedOut(Node node, ImportInfoImpl info) throws RepositoryException {
        boolean isCheckedOut;
        boolean bl = isCheckedOut = !node.isNodeType("mix:versionable") || node.isCheckedOut();
        if (!isCheckedOut) {
            info.registerToVersion(node.getPath());
            try {
                node.checkout();
            }
            catch (RepositoryException e) {
                ImportInfoImpl.log.warn("error while checkout node (ignored)", (Throwable)e);
            }
        }
    }
}

