/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config.validation;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Region;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidator;

public class ConfigurationValidator {
    public static final List<String> ALLOWED_PROPERTIES = Arrays.asList("service.description", "service.vendor", "service.ranking");
    private final PropertyValidator propertyValidator = new PropertyValidator();

    public ConfigurationValidationResult validate(Configuration config, ConfigurableEntity desc, Region region) {
        return this.validate(config, desc, region, Mode.STRICT);
    }

    public ConfigurationValidationResult validate(Configuration config, ConfigurableEntity desc, Region region, Mode mode) {
        Mode validationMode = desc.getMode() != null ? desc.getMode() : (mode != null ? mode : Mode.STRICT);
        ConfigurationValidationResult result = new ConfigurationValidationResult();
        if (config.isFactoryConfiguration()) {
            if (!(desc instanceof FactoryConfigurationDescription)) {
                result.getErrors().add("Factory configuration cannot be validated against non factory configuration description");
            } else {
                this.validateProperties(config, desc, result.getPropertyResults(), region, validationMode);
            }
        } else if (!(desc instanceof ConfigurationDescription)) {
            result.getErrors().add("Configuration cannot be validated against factory configuration description");
        } else {
            this.validateProperties(config, desc, result.getPropertyResults(), region, validationMode);
        }
        if (desc.getDeprecated() != null) {
            result.getWarnings().add(desc.getDeprecated());
        }
        return result;
    }

    void validateProperties(Configuration configuration, ConfigurableEntity desc, Map<String, PropertyValidationResult> results, Region region, Mode mode) {
        Dictionary properties = configuration.getConfigurationProperties();
        for (Map.Entry<String, PropertyDescription> propEntry : desc.getPropertyDescriptions().entrySet()) {
            Object value = properties.get(propEntry.getKey());
            PropertyValidationResult result = this.propertyValidator.validate(value, propEntry.getValue(), mode);
            results.put(propEntry.getKey(), result);
        }
        Enumeration keyEnum = properties.keys();
        while (keyEnum.hasMoreElements()) {
            String propName = (String)keyEnum.nextElement();
            if (desc.getPropertyDescriptions().containsKey(propName)) continue;
            PropertyValidationResult result = new PropertyValidationResult();
            results.put(propName, result);
            if ("service.ranking".equalsIgnoreCase(propName)) {
                Object value = properties.get(propName);
                if (value instanceof Integer) continue;
                this.setResult(result, mode, "service.ranking must be of type Integer");
                continue;
            }
            if (this.isAllowedProperty(propName) || region == Region.INTERNAL) continue;
            result.getErrors().add("Property is not allowed");
        }
    }

    void setResult(PropertyValidationResult result, Mode validationMode, String msg) {
        if (validationMode == Mode.STRICT) {
            result.getErrors().add(msg);
        } else if (validationMode == Mode.LENIENT || validationMode == Mode.DEFINITIVE) {
            result.getWarnings().add(msg);
        }
        if (validationMode == Mode.DEFINITIVE || validationMode == Mode.SILENT_DEFINITIVE) {
            result.setUseDefaultValue(true);
        }
    }

    private boolean isAllowedProperty(String name) {
        for (String allowed : ALLOWED_PROPERTIES) {
            if (!allowed.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

