/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import java.io.IOException;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.felix.cm.json.Configurations;
import org.apache.sling.feature.extension.apiregions.api.config.DescribableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.Mode;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescription;

public abstract class ConfigurableEntity
extends DescribableEntity {
    private final Map<String, PropertyDescription> properties = Configurations.newConfiguration();
    private Mode mode;

    @Override
    public void clear() {
        super.clear();
        this.properties.clear();
        this.setMode(null);
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            String modeVal;
            JsonValue val = this.getAttributes().remove("properties");
            if (val != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    PropertyDescription prop = new PropertyDescription();
                    prop.fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    if (this.getPropertyDescriptions().put((String)innerEntry.getKey(), prop) == null) continue;
                    throw new IOException("Duplicate key for property description (keys are case-insensitive) : ".concat((String)innerEntry.getKey()));
                }
            }
            if ((modeVal = this.getString("mode")) != null) {
                this.setMode(Mode.valueOf(modeVal.toUpperCase()));
            }
        }
        catch (IllegalArgumentException | JsonException e) {
            throw new IOException(e);
        }
    }

    public Map<String, PropertyDescription> getPropertyDescriptions() {
        return this.properties;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.mode = value;
    }

    @Override
    JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder objBuilder = super.createJson();
        if (!this.getPropertyDescriptions().isEmpty()) {
            JsonObjectBuilder propBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, PropertyDescription> entry : this.getPropertyDescriptions().entrySet()) {
                propBuilder.add(entry.getKey(), entry.getValue().createJson());
            }
            objBuilder.add("properties", propBuilder);
        }
        if (this.getMode() != null) {
            objBuilder.add("mode", this.getMode().name());
        }
        return objBuilder;
    }
}

