/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.List;
import java.util.Stack;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.sling.feature.cpconverter.accesscontrol.AccessControlEntry;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.handlers.AbstractPolicyEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.AbstractPolicyParser;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class RepPrincipalPolicyEntryHandler
extends AbstractPolicyEntryHandler {
    public RepPrincipalPolicyEntryHandler() {
        super("/jcr_root(.*/)_rep_principalPolicy.xml");
    }

    @Override
    @NotNull
    AbstractPolicyParser createPolicyParser(@NotNull RepoPath repositoryPath, @NotNull AclManager aclManager, @NotNull TransformerHandler handler) {
        return new RepPrincipalPolicyParser(repositoryPath, aclManager, handler);
    }

    private static final class RepPrincipalPolicyParser
    extends AbstractPolicyParser {
        private static final String REP_RESTRICTIONS = "rep:Restrictions";
        private static final String REP_PRINCIPAL_POLICY = "rep:PrincipalPolicy";
        private static final String REP_PRINCIPAL_ENTRY = "rep:PrincipalEntry";
        private static final String REP_EFFECTIVE_PATH = "rep:effectivePath";
        private final Stack<AccessControlEntry> aces = new Stack();
        private boolean processCurrentAcl = false;
        private String principalName = null;

        public RepPrincipalPolicyParser(RepoPath repositoryPath, AclManager aclManager, TransformerHandler handler) {
            super(REP_PRINCIPAL_POLICY, repositoryPath, aclManager, handler);
        }

        @Override
        protected void onJcrRootElement(String uri, String localName, String qName, Attributes attributes) {
            super.onJcrRootElement(uri, localName, qName, attributes);
            this.principalName = attributes.getValue("rep:principalName");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.onRepAclNode) {
                String primaryType = attributes.getValue("jcr:primaryType");
                if (REP_PRINCIPAL_ENTRY.equals(primaryType)) {
                    if (this.principalName == null) {
                        throw new IllegalStateException("isolated principal-based access control entry. no principal found.");
                    }
                    List<String> privileges = RepPrincipalPolicyParser.extractValues(attributes.getValue("rep:privileges"));
                    RepoPath effectivePath = new RepoPath(RepPrincipalPolicyParser.extractEffectivePath(attributes.getValue(REP_EFFECTIVE_PATH)));
                    AccessControlEntry ace = new AccessControlEntry(true, privileges, effectivePath, true);
                    this.processCurrentAcl = this.aclManager.addAcl(this.principalName, ace);
                    if (this.processCurrentAcl) {
                        this.aces.add(ace);
                    } else {
                        this.hasRejectedNodes = true;
                    }
                } else if (REP_RESTRICTIONS.equals(primaryType) && !this.aces.isEmpty() && this.processCurrentAcl) {
                    AccessControlEntry ace = this.aces.peek();
                    this.aces.add(ace);
                    this.addRestrictions(ace, attributes);
                }
            } else {
                super.startElement(uri, localName, qName, attributes);
            }
            if (!this.onRepAclNode || !this.processCurrentAcl) {
                this.handler.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.onRepAclNode && this.processCurrentAcl && !this.aces.isEmpty()) {
                this.aces.pop();
            } else {
                this.processCurrentAcl = false;
                this.principalName = null;
                this.handler.endElement(uri, localName, qName);
            }
        }

        @Override
        boolean isRestriction(@NotNull String attributeName) {
            if (REP_EFFECTIVE_PATH.equals(attributeName)) {
                return false;
            }
            return super.isRestriction(attributeName);
        }

        @NotNull
        private static String extractEffectivePath(@Nullable String value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            return DocViewProperty.parse((String)REP_EFFECTIVE_PATH, (String)value).values[0];
        }
    }
}

