/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import java.util.Calendar;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.JcrWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;

public class JcrRegisteredPackage
implements RegisteredPackage {
    private JcrPackage pkg;
    private VaultPackage vltPkg;

    public JcrRegisteredPackage(JcrPackage pkg) throws IOException, RepositoryException {
        this.pkg = pkg;
        this.vltPkg = pkg.getPackage();
    }

    public JcrPackage getJcrPackage() {
        return this.pkg;
    }

    @Override
    @Nonnull
    public PackageId getId() {
        return this.vltPkg.getId();
    }

    @Override
    @Nonnull
    public VaultPackage getPackage() throws IOException {
        return this.vltPkg;
    }

    @Override
    public boolean isInstalled() {
        try {
            return this.pkg.isInstalled();
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public long getSize() {
        return this.pkg.getSize();
    }

    @Override
    @CheckForNull
    public Calendar getInstallationTime() {
        try {
            JcrPackageDefinition def = this.pkg.getDefinition();
            return def == null ? null : def.getLastUnpacked();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        this.vltPkg.close();
        this.vltPkg = null;
        this.pkg.close();
        this.pkg = null;
    }

    @Override
    public int compareTo(RegisteredPackage o) {
        return this.getId().compareTo(o.getId());
    }

    @Override
    public Dependency[] getDependencies() {
        return this.vltPkg.getDependencies();
    }

    @Override
    public WorkspaceFilter getWorkspaceFilter() {
        try {
            return JcrWorkspaceFilter.loadFilter(this.pkg.getDefNode());
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public PackageProperties getPackageProperties() throws IOException {
        return this.getPackage().getProperties();
    }
}

