/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.acl.SystemUser;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.apache.sling.feature.cpconverter.shared.AbstractJcrNodeParser;
import org.xml.sax.Attributes;

public final class SystemUsersEntryHandler
extends AbstractRegexEntryHandler {
    public SystemUsersEntryHandler() {
        super("/jcr_root(/home/users/.*/)\\.content.xml");
    }

    @Override
    public void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        Matcher matcher = this.getPattern().matcher(path);
        if (matcher.matches()) {
            path = matcher.group(1);
        }
        Path currentPath = Paths.get(path, new String[0]).getParent();
        SystemUserParser systemUserParser = new SystemUserParser(converter, currentPath);
        try (InputStream input = archive.openInputStream(entry);){
            systemUserParser.parse(input);
        }
    }

    private static final class SystemUserParser
    extends AbstractJcrNodeParser<Void> {
        private static final String REP_SYSTEM_USER = "rep:SystemUser";
        private static final String REP_AUTHORIZABLE_ID = "rep:authorizableId";
        private final ContentPackage2FeatureModelConverter converter;
        private final Path path;

        public SystemUserParser(ContentPackage2FeatureModelConverter converter, Path path) {
            super(REP_SYSTEM_USER);
            this.converter = converter;
            this.path = path;
        }

        @Override
        protected void onJcrRootElement(String uri, String localName, String qName, Attributes attributes) {
            String authorizableId = attributes.getValue(REP_AUTHORIZABLE_ID);
            if (authorizableId != null && !authorizableId.isEmpty()) {
                this.converter.getAclManager().addSystemUser(new SystemUser(authorizableId, this.path));
            }
        }

        @Override
        protected Void getParsingResult() {
            return null;
        }
    }
}

