/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.cli;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.acl.DefaultAclManager;
import org.apache.sling.feature.cpconverter.artifacts.DefaultArtifactsDeployer;
import org.apache.sling.feature.cpconverter.cli.ShutDownHook;
import org.apache.sling.feature.cpconverter.features.DefaultFeaturesManager;
import org.apache.sling.feature.cpconverter.filtering.RegexBasedResourceFilter;
import org.apache.sling.feature.cpconverter.handlers.DefaultEntryHandlersManager;
import org.apache.sling.feature.cpconverter.vltpkg.DefaultPackagesEventsEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="cp2fm", description={"Apache Sling Content Package to Sling Feature converter"}, footer={"Copyright(c) 2019 The Apache Software Foundation."})
public final class ContentPackage2FeatureModelConverterLauncher
implements Runnable {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display the usage message."})
    private boolean helpRequested;
    @CommandLine.Option(names={"-X", "--verbose"}, description={"Produce execution debug output."})
    private boolean debug;
    @CommandLine.Option(names={"-q", "--quiet"}, description={"Log errors only."})
    private boolean quiet;
    @CommandLine.Option(names={"-v", "--version"}, description={"Display version information."})
    private boolean printVersion;
    @CommandLine.Option(names={"-s", "--strict-validation"}, description={"Flag to mark the content-package input file being strict validated."}, required=false, defaultValue="false")
    private boolean strictValidation = false;
    @CommandLine.Option(names={"-m", "--merge-configurations"}, description={"Flag to mark OSGi configurations with same PID will be merged, the tool will fail otherwise."}, required=false, defaultValue="false")
    private boolean mergeConfigurations = false;
    @CommandLine.Option(names={"-b", "--bundles-start-order"}, description={"The order to start detected bundles."}, required=false)
    private int bundlesStartOrder = 0;
    @CommandLine.Option(names={"-f", "--filtering-patterns"}, description={"Regex based pattern(s) to reject content-package archive entries."}, required=false)
    private String[] filteringPatterns;
    @CommandLine.Option(names={"-a", "--artifacts-output-directory"}, description={"The output directory where the artifacts will be deployed."}, required=true)
    private File artifactsOutputDirectory;
    @CommandLine.Option(names={"-o", "--features-output-directory"}, description={"The output directory where the Feature File will be generated."}, required=true)
    private File featureModelsOutputDirectory;
    @CommandLine.Option(names={"-i", "--artifact-id"}, description={"The optional Artifact Id the Feature File will have, once generated; it will be derived, if not specified."}, required=false)
    private String artifactIdOverride;
    @CommandLine.Option(names={"-p", "--fm-prefix"}, description={"The optional prefix of the output file"}, required=false)
    private String fmPrefix;
    @CommandLine.Option(names={"-r", "--api-region"}, description={"The API Regions assigned to the generated features"}, required=false)
    private List<String> apiRegions;
    @CommandLine.Option(names={"-D", "--define"}, description={"Define a system property"}, required=false)
    private Map<String, String> properties = new HashMap<String, String>();
    @CommandLine.Parameters(arity="1..*", paramLabel="content-packages", description={"The content-package input file(s)."})
    private File[] contentPackages;
    @CommandLine.Option(names={"-Z", "--fail-on-mixed-packages"}, description={"Fail the conversion if the resulting attached content-package is MIXED type"}, required=false)
    private boolean failOnMixedPackages = false;

    @Override
    public void run() {
        if (this.quiet) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "error");
        } else if (this.debug) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "debug");
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        }
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showLogName", "false");
        String appName = this.getClass().getAnnotation(CommandLine.Command.class).description()[0];
        Logger logger = LoggerFactory.getLogger((String)appName);
        Runtime.getRuntime().addShutdownHook(new ShutDownHook(logger));
        if (this.printVersion) {
            ContentPackage2FeatureModelConverterLauncher.printVersion(logger);
        }
        logger.info(appName);
        logger.info("");
        try {
            DefaultFeaturesManager featuresManager = new DefaultFeaturesManager(this.mergeConfigurations, this.bundlesStartOrder, this.featureModelsOutputDirectory, this.artifactIdOverride, this.fmPrefix, this.properties);
            if (this.apiRegions != null) {
                featuresManager.setAPIRegions(this.apiRegions);
            }
            ContentPackage2FeatureModelConverter converter = new ContentPackage2FeatureModelConverter(this.strictValidation).setFeaturesManager(featuresManager).setBundlesDeployer(new DefaultArtifactsDeployer(this.artifactsOutputDirectory)).setEntryHandlersManager(new DefaultEntryHandlersManager()).setAclManager(new DefaultAclManager()).setEmitter(DefaultPackagesEventsEmitter.open(this.featureModelsOutputDirectory)).setFailOnMixedPackages(this.failOnMixedPackages);
            if (this.filteringPatterns != null && this.filteringPatterns.length > 0) {
                RegexBasedResourceFilter filter = new RegexBasedResourceFilter();
                for (String filteringPattern : this.filteringPatterns) {
                    filter.addFilteringPattern(filteringPattern);
                }
                converter.setResourceFilter(filter);
            }
            converter.convert(this.contentPackages);
            logger.info("+-----------------------------------------------------+");
            logger.info("{} SUCCESS", (Object)appName);
        }
        catch (Throwable t) {
            logger.info("+-----------------------------------------------------+");
            logger.info("{} FAILURE", (Object)appName);
            logger.info("+-----------------------------------------------------+");
            if (this.debug) {
                logger.error("Unable to convert content-package {}:", (Object)this.contentPackages, (Object)t);
            } else {
                logger.error("Unable to convert content-package {}: {}", (Object)this.contentPackages, (Object)t.getMessage());
            }
            logger.info("+-----------------------------------------------------+");
            System.exit(1);
        }
    }

    private static void printVersion(Logger logger) {
        logger.info("{} v{} (built on {})", new Object[]{System.getProperty("project.artifactId"), System.getProperty("project.version"), System.getProperty("build.timestamp")});
        logger.info("Java version: {}, vendor: {}", (Object)System.getProperty("java.version"), (Object)System.getProperty("java.vendor"));
        logger.info("Java home: {}", (Object)System.getProperty("java.home"));
        logger.info("Default locale: {}_{}, platform encoding: {}", new Object[]{System.getProperty("user.language"), System.getProperty("user.country"), System.getProperty("sun.jnu.encoding")});
        logger.info("Default Time Zone: {}", (Object)TimeZone.getDefault().getDisplayName());
        logger.info("OS name: \"{}\", version: \"{}\", arch: \"{}\", family: \"{}\"", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), ContentPackage2FeatureModelConverterLauncher.getOsFamily()});
        logger.info("+-----------------------------------------------------+");
    }

    private static final String getOsFamily() {
        String osName = System.getProperty("os.name").toLowerCase();
        String pathSep = System.getProperty("path.separator");
        if (osName.indexOf("windows") != -1) {
            return "windows";
        }
        if (osName.indexOf("os/2") != -1) {
            return "os/2";
        }
        if (osName.indexOf("z/os") != -1 || osName.indexOf("os/390") != -1) {
            return "z/os";
        }
        if (osName.indexOf("os/400") != -1) {
            return "os/400";
        }
        if (pathSep.equals(";")) {
            return "dos";
        }
        if (osName.indexOf("mac") != -1) {
            if (osName.endsWith("x")) {
                return "mac";
            }
            return "unix";
        }
        if (osName.indexOf("nonstop_kernel") != -1) {
            return "tandem";
        }
        if (osName.indexOf("openvms") != -1) {
            return "openvms";
        }
        if (pathSep.equals(":")) {
            return "unix";
        }
        return "undefined";
    }

    public static void main(String[] args) {
        CommandLine.run((Runnable)new ContentPackage2FeatureModelConverterLauncher(), (String[])args);
    }
}

