/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Configuration
implements Comparable<Configuration> {
    public static final String CONFIGURATOR_PREFIX = ":configurator:";
    public static final String PROP_PREFIX = ":configurator:feature:";
    public static final String PROP_ARTIFACT_ID = ":configurator:feature:service.bundleLocation";
    private final String pid;
    private final Dictionary<String, Object> properties = new OrderedDictionary();

    public Configuration(String pid) {
        if (pid == null) {
            throw new IllegalArgumentException("pid must not be null");
        }
        this.pid = pid;
    }

    @Override
    public int compareTo(Configuration o) {
        return this.pid.compareTo(o.pid);
    }

    public String getPid() {
        return this.pid;
    }

    public static boolean isFactoryConfiguration(String pid) {
        return pid.contains("~");
    }

    public static String getFactoryPid(String pid) {
        int pos = pid.indexOf(126);
        if (pos != -1) {
            return pid.substring(0, pos);
        }
        return null;
    }

    public static String getName(String pid) {
        int pos = pid.indexOf(126);
        if (pos != -1) {
            return pid.substring(pos + 1);
        }
        return null;
    }

    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    public Dictionary<String, Object> getConfigurationProperties() {
        Hashtable<String, Object> p = new Hashtable<String, Object>();
        Enumeration<String> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.startsWith(CONFIGURATOR_PREFIX)) continue;
            ((Dictionary)p).put(key, this.properties.get(key));
        }
        return p;
    }

    public Configuration copy(String aPid) {
        Configuration result = new Configuration(aPid);
        Enumeration<String> keyEnum = this.getProperties().keys();
        while (keyEnum.hasMoreElements()) {
            String key = keyEnum.nextElement();
            result.getProperties().put(key, this.getProperties().get(key));
        }
        return result;
    }

    public String toString() {
        return "Configuration [pid=" + this.pid + ", properties=" + this.properties + "]";
    }

    static class OrderedDictionary
    extends Dictionary<String, Object>
    implements Map<String, Object> {
        private final Map<String, Object> map = new LinkedHashMap<String, Object>();

        OrderedDictionary() {
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Enumeration<String> keys() {
            return new EnumarationImpl<String>(this.map.keySet().iterator());
        }

        @Override
        public Enumeration<Object> elements() {
            return new EnumarationImpl<Object>(this.map.values().iterator());
        }

        @Override
        public Object get(Object key) {
            return this.map.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return this.map.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof OrderedDictionary)) {
                Dictionary other;
                if (o instanceof Dictionary && (other = (Dictionary)o).size() == this.size()) {
                    Enumeration<String> iter = this.keys();
                    while (iter.hasMoreElements()) {
                        String key = iter.nextElement();
                        Object ov = other.get(key);
                        if (ov == null) {
                            return false;
                        }
                        Object tv = this.get(key);
                        if (tv.equals(ov)) continue;
                        return false;
                    }
                    return true;
                }
                if (o instanceof Map) {
                    return this.map.equals(o);
                }
                return false;
            }
            return this.map.equals(((OrderedDictionary)o).map);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return this.map.toString();
        }

        private static class EnumarationImpl<E>
        implements Enumeration<E> {
            private final Iterator<E> iterator;

            public EnumarationImpl(Iterator<E> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public E nextElement() {
                return this.iterator.next();
            }
        }
    }
}

