/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.feature.ArtifactId;

public class Artifact
implements Comparable<Artifact> {
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_START_ORDER = "start-order";
    private final ArtifactId id;
    private final Map<String, String> metadata = new HashMap<String, String>();

    public Artifact(ArtifactId id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        this.id = id;
    }

    public ArtifactId getId() {
        return this.id;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Set<ArtifactId> getAliases(boolean includeMain) {
        String aliases;
        HashSet<ArtifactId> artifactIds = new HashSet<ArtifactId>();
        if (includeMain) {
            artifactIds.add(this.getId());
        }
        if ((aliases = this.getMetadata().get(KEY_ALIAS)) != null) {
            for (String alias : aliases.split(",")) {
                if ((alias = alias.trim()).indexOf(58) == alias.lastIndexOf(58)) {
                    alias = alias + ":0.0.0";
                }
                artifactIds.add(ArtifactId.fromMvnId(alias));
            }
        }
        return artifactIds;
    }

    public int getStartOrder() {
        int startOrder;
        String order = this.getMetadata().get(KEY_START_ORDER);
        if (order != null) {
            startOrder = Integer.parseInt(order);
            if (startOrder < 0) {
                throw new IllegalStateException("Start order must be >= 0 but is " + order);
            }
        } else {
            startOrder = 0;
        }
        return startOrder;
    }

    public void setStartOrder(int startOrder) {
        if (startOrder < 0) {
            throw new IllegalArgumentException("Start order must be >= 0 but is " + startOrder);
        }
        if (startOrder == 0) {
            this.getMetadata().remove(KEY_START_ORDER);
        } else {
            this.getMetadata().put(KEY_START_ORDER, String.valueOf(startOrder));
        }
    }

    @Override
    public int compareTo(Artifact o) {
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((Artifact)obj).id);
    }

    public Artifact copy(ArtifactId id) {
        Artifact result = new Artifact(id);
        result.getMetadata().putAll(this.getMetadata());
        return result;
    }

    public String toString() {
        return "Artifact [id=" + this.id.toMvnId() + "]";
    }
}

