/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.SyntheticPathFilter;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

public class VaultPackageAssembler
implements EntryHandler,
FileFilter {
    private static final String NAME_PATH = "path";
    private static final String JCR_ROOT_DIR = "jcr_root";
    private static final String[] INCLUDE_RESOURCES = new String[]{"definition/.content.xml", "config.xml", "settings.xml"};
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"), "syntethic-content-packages");
    private static final Pattern OSGI_BUNDLE_PATTERN = Pattern.compile("(jcr_root)?/apps/[^/]+/install(\\.([^/]+))?/.+\\.jar");
    private final DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
    private final Set<Dependency> dependencies;
    private final File storingDirectory;
    private final Properties properties;

    public static VaultPackageAssembler create(VaultPackage vaultPackage) {
        return VaultPackageAssembler.create(vaultPackage, vaultPackage.getMetaInf().getFilter());
    }

    public static File createSynthetic(VaultPackage vaultPackage) throws Exception {
        DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
        PathFilterSet filterSet = new PathFilterSet();
        SyntheticPathFilter pathFilter = new SyntheticPathFilter();
        filterSet.addExclude((Filter)pathFilter);
        filterSet.setImportMode(ImportMode.MERGE);
        filter.add(filterSet);
        return VaultPackageAssembler.create(vaultPackage, (WorkspaceFilter)filter).createPackage();
    }

    private static VaultPackageAssembler create(VaultPackage vaultPackage, WorkspaceFilter filter) {
        PackageId packageId = vaultPackage.getId();
        String fileName = packageId.toString().replaceAll("/", "-").replaceAll(":", "-") + "-" + vaultPackage.getFile().getName();
        File storingDirectory = new File(TMP_DIR, fileName + "-deflated");
        if (storingDirectory.exists()) {
            try {
                FileUtils.deleteDirectory((File)storingDirectory);
            }
            catch (IOException e) {
                throw new FolderDeletionException("Unable to delete existing deflated folder: '" + storingDirectory + "'", e);
            }
        }
        File jcrRootDirectory = new File(storingDirectory, JCR_ROOT_DIR);
        jcrRootDirectory.mkdirs();
        PackageProperties packageProperties = vaultPackage.getProperties();
        Properties properties = new Properties();
        properties.setProperty("version", packageProperties.getProperty("version") + '-' + "cp2fm-converted");
        for (String key : new String[]{"group", "name", "createdBy", "created", "requiresRoot", "packageType", "acHandling", NAME_PATH}) {
            String value = packageProperties.getProperty(key);
            if (value == null || value.isEmpty()) continue;
            properties.setProperty(key, value);
        }
        Set<Dependency> dependencies = VaultPackageUtils.getDependencies(vaultPackage);
        VaultPackageAssembler assembler = new VaultPackageAssembler(storingDirectory, properties, dependencies);
        assembler.mergeFilters(filter);
        return assembler;
    }

    @Override
    public boolean matches(String path) {
        return true;
    }

    @Override
    public void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        this.addEntry(path, archive, entry);
    }

    private VaultPackageAssembler(File storingDirectory, Properties properties, Set<Dependency> dependencies) {
        this.storingDirectory = storingDirectory;
        this.properties = properties;
        this.dependencies = dependencies;
    }

    public void mergeFilters(WorkspaceFilter filter) {
        for (PathFilterSet pathFilterSet : filter.getFilterSets()) {
            if (OSGI_BUNDLE_PATTERN.matcher(pathFilterSet.getRoot()).matches()) continue;
            this.filter.add(pathFilterSet);
        }
    }

    public void addEntry(String path, Archive archive, Archive.Entry entry) throws IOException {
        try (InputStream input = archive.openInputStream(entry);){
            this.addEntry(path, input);
        }
    }

    public void addEntry(String path, File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            this.addEntry(path, input);
        }
    }

    public void addEntry(String path, InputStream input) throws IOException {
        try (OutputStream output = this.createEntry(path);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    public OutputStream createEntry(String path) throws IOException {
        File target = new File(this.storingDirectory, path);
        target.getParentFile().mkdirs();
        return new FileOutputStream(target);
    }

    public File getEntry(String path) {
        if (!path.startsWith(JCR_ROOT_DIR)) {
            path = JCR_ROOT_DIR + path;
        }
        return new File(this.storingDirectory, path);
    }

    public void updateDependencies(Map<PackageId, Set<Dependency>> mutableContentsIds) {
        for (Dependency dependency : this.dependencies) {
            for (Map.Entry<PackageId, Set<Dependency>> mutableContentId : mutableContentsIds.entrySet()) {
                if (!dependency.matches(mutableContentId.getKey())) continue;
                this.dependencies.remove(dependency);
                this.dependencies.addAll((Collection<Dependency>)mutableContentId.getValue());
            }
        }
    }

    public File createPackage() throws IOException {
        return this.createPackage(TMP_DIR);
    }

    public File createPackage(File outputDirectory) throws IOException {
        File metaDir = new File(this.storingDirectory, "META-INF/vault");
        if (!metaDir.exists()) {
            metaDir.mkdirs();
        }
        VaultPackageUtils.setDependencies(this.dependencies, this.properties);
        File xmlProperties = new File(metaDir, "properties.xml");
        try (FileOutputStream fos = new FileOutputStream(xmlProperties);){
            this.properties.storeToXML(fos, null);
        }
        this.computeFilters(outputDirectory);
        File xmlFilter = new File(metaDir, "filter.xml");
        try (String[] input = this.filter.getSource();
             FileOutputStream output = new FileOutputStream(xmlFilter);){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        for (String resource : INCLUDE_RESOURCES) {
            try (InputStream input = this.getClass().getResourceAsStream(resource);){
                this.addEntry("jcr_root/" + resource, input);
            }
        }
        ZipArchiver archiver = new ZipArchiver();
        archiver.setIncludeEmptyDirs(true);
        String destFileName = this.storingDirectory.getName().substring(0, this.storingDirectory.getName().lastIndexOf(45));
        File destFile = new File(TMP_DIR, destFileName);
        archiver.setDestFile(destFile);
        archiver.addFileSet((FileSet)new DefaultFileSet(this.storingDirectory));
        archiver.createArchive();
        return destFile;
    }

    private void computeFilters(File outputDirectory) {
        File jcrRootDir = new File(outputDirectory, JCR_ROOT_DIR);
        if (jcrRootDir.exists() && jcrRootDir.isDirectory()) {
            for (File child : jcrRootDir.listFiles(this)) {
                File lowestCommonAncestor = this.lowestCommonAncestor((TreeNode)new TreeNode((File)child)).val;
                if (lowestCommonAncestor == null) continue;
                String root = outputDirectory.toURI().relativize(lowestCommonAncestor.toURI()).getPath();
                this.filter.add(new PathFilterSet(root));
            }
        }
    }

    @Override
    public boolean accept(File pathname) {
        return pathname.isDirectory();
    }

    private TreeNode lowestCommonAncestor(TreeNode root) {
        int currMaxDepth = 0;
        int countMaxDepth = 0;
        TreeNode node = null;
        for (File child : root.val.listFiles(this)) {
            TreeNode temp = this.lowestCommonAncestor(new TreeNode(child));
            if (temp == null) continue;
            if (temp.maxDepth > currMaxDepth) {
                currMaxDepth = temp.maxDepth;
                node = temp;
                countMaxDepth = 1;
                continue;
            }
            if (temp.maxDepth != currMaxDepth) continue;
            ++countMaxDepth;
        }
        if (countMaxDepth > 1) {
            root.maxDepth = node.maxDepth + 1;
            return root;
        }
        if (countMaxDepth == 1) {
            ++node.maxDepth;
            return node;
        }
        if (countMaxDepth == 0) {
            root.maxDepth = 2;
            return root;
        }
        return null;
    }

    public static class FolderDeletionException
    extends RuntimeException {
        public FolderDeletionException(String message) {
            super(message);
        }

        public FolderDeletionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class TreeNode {
        File val;
        int maxDepth;

        TreeNode(File x) {
            this.val = x;
            this.maxDepth = 0;
        }
    }
}

