/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Dictionary;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.felix.configurator.impl.json.JSONUtil;
import org.apache.felix.configurator.impl.json.TypeConverter;
import org.apache.felix.configurator.impl.model.Config;
import org.apache.felix.configurator.impl.model.ConfigurationFile;
import org.apache.sling.feature.cpconverter.handlers.AbstractConfigurationEntryHandler;

public final class JsonConfigurationEntryHandler
extends AbstractConfigurationEntryHandler {
    public JsonConfigurationEntryHandler() {
        super("cfg\\.json");
    }

    @Override
    protected Dictionary<String, Object> parseConfiguration(String name, InputStream input) throws Exception {
        StringBuilder content = new StringBuilder().append("{ \"").append(name).append("\" : ");
        try (InputStreamReader reader = new InputStreamReader(input);){
            StringWriter writer = new StringWriter();
            Iterator iterator = null;
            try {
                IOUtils.copy((Reader)reader, (Writer)writer);
                content.append(writer.toString());
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (iterator != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        content.append("}");
        JSONUtil.Report report = new JSONUtil.Report();
        ConfigurationFile configuration = JSONUtil.readJSON((TypeConverter)new TypeConverter(null), (String)name, (URL)new URL("file://content-package/" + name), (long)0L, (String)content.toString(), (JSONUtil.Report)report);
        if (!report.errors.isEmpty() || !report.warnings.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Errors in configuration:");
            for (String w : report.warnings) {
                builder.append("\n");
                builder.append(w);
            }
            for (String e : report.errors) {
                builder.append("\n");
                builder.append(e);
            }
            throw new IOException(builder.toString());
        }
        return ((Config)configuration.getConfigurations().get(0)).getProperties();
    }
}

