/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.features;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

final class RunmodeMapper {
    private static final String FILENAME = "runmode.mapping";
    private static final String DEFAULT = "(default)";
    private final File runmodeMappingFile;
    private final Properties properties;

    public static RunmodeMapper open(File featureModelsOutputDirectory) throws IOException {
        Properties properties = new Properties();
        File runmodeMappingFile = new File(featureModelsOutputDirectory, FILENAME);
        if (runmodeMappingFile.exists()) {
            try (FileInputStream input = new FileInputStream(runmodeMappingFile);){
                properties.load(input);
            }
        }
        return new RunmodeMapper(runmodeMappingFile, properties);
    }

    private RunmodeMapper(File runmodeMappingFile, Properties properties) {
        this.runmodeMappingFile = runmodeMappingFile;
        this.properties = properties;
    }

    public void addOrUpdate(String runMode, String jsonFileName) {
        String value;
        if (runMode == null) {
            runMode = DEFAULT;
        }
        value = (value = this.properties.getProperty(runMode)) != null && !value.contains(jsonFileName) ? value + ',' + jsonFileName : jsonFileName;
        this.properties.setProperty(runMode, value);
    }

    public void save() throws IOException {
        try (FileOutputStream output = new FileOutputStream(this.runmodeMappingFile);){
            this.properties.store(output, "File edited by the Apache Sling Content Package to Sling Feature converter");
        }
    }
}

