/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.sling.feature.cpconverter.vltpkg.PackagesEventsEmitter;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;

public final class DefaultPackagesEventsEmitter
implements PackagesEventsEmitter {
    private static final String FILENAME = "content-packages.csv";
    private static final String PATH_SEPARATOR_CHAR = "!";
    private final Stack<String> paths = new Stack();
    private final Stack<PackageId> hierarchy = new Stack();
    private final PrintWriter writer;
    private VaultPackage current;

    public static DefaultPackagesEventsEmitter open(File featureModelsOutputDirectory) throws IOException {
        if (!featureModelsOutputDirectory.exists()) {
            featureModelsOutputDirectory.mkdirs();
        }
        File contentPackagesFiles = new File(featureModelsOutputDirectory, FILENAME);
        return new DefaultPackagesEventsEmitter(new FileWriter(contentPackagesFiles));
    }

    protected DefaultPackagesEventsEmitter(Writer writer) {
        this.writer = new PrintWriter(writer, true);
    }

    @Override
    public void start() {
        this.writer.printf("# File created on %s by the Apache Sling Content Package to Sling Feature converter%n", new Date()).printf("# content-package path, content-package ID, content-package type, content-package parent ID, path in parent content-package, absolute path%n", new Object[0]);
    }

    @Override
    public void end() {
        this.writer.close();
        this.paths.clear();
        this.hierarchy.clear();
    }

    @Override
    public void startPackage(VaultPackage vaultPackage) {
        this.paths.add(vaultPackage.getFile().getAbsolutePath());
        this.hierarchy.add(vaultPackage.getId());
        this.current = vaultPackage;
        this.writer.printf("%s,%s,%s,,,%n", this.paths.peek(), this.hierarchy.peek(), VaultPackageUtils.detectPackageType(vaultPackage));
    }

    @Override
    public void endPackage() {
        this.paths.pop();
        this.hierarchy.pop();
    }

    @Override
    public void startSubPackage(String path, VaultPackage vaultPackage) {
        this.paths.add(path);
        String absolutePath = this.paths.stream().collect(Collectors.joining(PATH_SEPARATOR_CHAR));
        this.writer.printf("%s,%s,%s,%s,%s,%s%n", this.current.getFile().getAbsolutePath(), vaultPackage.getId(), VaultPackageUtils.detectPackageType(vaultPackage), this.hierarchy.peek(), path, absolutePath);
        this.hierarchy.add(vaultPackage.getId());
    }

    @Override
    public void endSubPackage() {
        this.endPackage();
    }
}

