/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.File;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseVaultPackageScanner {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final PackageManager packageManager;
    protected final boolean strictValidation;

    public BaseVaultPackageScanner(boolean strictValidation) {
        this((PackageManager)new PackageManagerImpl(), strictValidation);
    }

    public BaseVaultPackageScanner(PackageManager packageManager, boolean strictValidation) {
        this.packageManager = packageManager;
        this.strictValidation = strictValidation;
    }

    public VaultPackage open(File vaultPackage) throws Exception {
        Objects.requireNonNull(vaultPackage, "Impossible to process a null vault package");
        return this.packageManager.open(vaultPackage, this.strictValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverse(File vaultPackageFile, boolean closeOnTraversed) throws Exception {
        VaultPackage vaultPackage = null;
        try {
            vaultPackage = this.open(vaultPackageFile);
            this.traverse(vaultPackage);
        }
        finally {
            if (closeOnTraversed && vaultPackage != null) {
                vaultPackage.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverse(VaultPackage vaultPackage) throws Exception {
        Objects.requireNonNull(vaultPackage, "Impossible to process a null vault package");
        PackageProperties properties = vaultPackage.getProperties();
        ImportOptions importOptions = new ImportOptions();
        String cndPattern = properties.getProperty("cndPattern");
        if (cndPattern != null && !cndPattern.isEmpty()) {
            importOptions.setCndPattern(cndPattern);
        }
        this.addCdnPattern(importOptions.getCndPattern());
        try (Archive archive = vaultPackage.getArchive();){
            archive.open(this.strictValidation);
            Archive.Entry root = archive.getRoot();
            this.traverse(null, archive, root);
        }
    }

    private void traverse(String path, Archive archive, Archive.Entry entry) throws Exception {
        String entryPath = BaseVaultPackageScanner.newPath(path, entry.getName());
        if (entry.isDirectory()) {
            this.onDirectory(entryPath, archive, entry);
            for (Archive.Entry child : entry.getChildren()) {
                this.traverse(entryPath, archive, child);
            }
            return;
        }
        this.logger.debug("Processing entry {}...", (Object)entryPath);
        this.onFile(entryPath, archive, entry);
        this.logger.debug("Entry {} successfully processed.", (Object)entryPath);
    }

    private static String newPath(String path, String entryName) {
        if (path == null) {
            return entryName;
        }
        return path + '/' + entryName;
    }

    protected void onDirectory(String path, Archive archive, Archive.Entry entry) throws Exception {
    }

    protected void onFile(String path, Archive archive, Archive.Entry entry) throws Exception {
    }

    protected void addCdnPattern(Pattern cndPattern) {
    }
}

