/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.sling.feature.cpconverter.handlers.AbstractConfigurationEntryHandler;
import org.apache.sling.feature.cpconverter.shared.AbstractJcrNodeParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class XmlConfigurationEntryHandler
extends AbstractConfigurationEntryHandler {
    public XmlConfigurationEntryHandler() {
        super("xml");
    }

    @Override
    protected Dictionary<String, Object> parseConfiguration(String name, InputStream input) throws Exception {
        JcrConfigurationHandler configurationHandler = new JcrConfigurationHandler();
        try {
            return (Dictionary)configurationHandler.parse(input);
        }
        catch (Exception e) {
            this.logger.warn("Current OSGi configuration does not represent a valid XML document, see nested exceptions", (Throwable)e);
            return null;
        }
    }

    private static final class JcrConfigurationHandler
    extends AbstractJcrNodeParser<Dictionary<String, Object>> {
        private static final String SLING_OSGICONFIG = "sling:OsgiConfig";
        private Dictionary<String, Object> configuration = null;

        public JcrConfigurationHandler() {
            super(SLING_OSGICONFIG);
        }

        @Override
        protected void onJcrRootElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.configuration = new Hashtable<String, Object>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeValue;
                String attributeQName = attributes.getQName(i);
                if (attributeQName.indexOf(58) != -1 || (attributeValue = attributes.getValue(i)) == null || attributeValue.isEmpty()) continue;
                DocViewProperty property = DocViewProperty.parse((String)attributeQName, (String)attributeValue);
                if (property.values.length <= 0) continue;
                if (property.isMulti) {
                    this.configuration.put(attributeQName, property.values);
                    continue;
                }
                this.configuration.put(attributeQName, property.values[0]);
            }
        }

        @Override
        protected Dictionary<String, Object> getParsingResult() {
            return this.configuration;
        }
    }
}

