/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.sling.feature.cpconverter.handlers.AbstractConfigurationEntryHandler;

public final class PropertiesConfigurationEntryHandler
extends AbstractConfigurationEntryHandler {
    public PropertiesConfigurationEntryHandler() {
        super("(cfg|properties)");
    }

    @Override
    protected Dictionary<String, Object> parseConfiguration(String name, InputStream input) throws Exception {
        Properties properties = new Properties();
        try (BufferedInputStream in = new BufferedInputStream(input);){
            in.mark(1);
            boolean isXml = 60 == in.read();
            in.reset();
            if (isXml) {
                properties.loadFromXML(in);
            } else {
                properties.load(in);
            }
        }
        Hashtable<String, Object> configuration = new Hashtable<String, Object>();
        Enumeration<Object> i = properties.keys();
        while (i.hasMoreElements()) {
            Object key = i.nextElement();
            ((Dictionary)configuration).put(key.toString(), properties.get(key));
        }
        return configuration;
    }
}

