/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.acl;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.acl.Acl;
import org.apache.sling.feature.cpconverter.acl.AclManager;
import org.apache.sling.feature.cpconverter.acl.PrimaryTypeParser;
import org.apache.sling.feature.cpconverter.acl.SystemUser;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;

public final class DefaultAclManager
implements AclManager {
    private static final String CONTENT_XML_FILE_NAME = ".content.xml";
    private static final String DEFAULT_TYPE = "sling:Folder";
    private final Set<SystemUser> preProvidedSystemUsers = new LinkedHashSet<SystemUser>();
    private final Set<Path> preProvidedSystemPaths = new HashSet<Path>();
    private final Set<Path> preProvidedPaths = new HashSet<Path>();
    private final Set<SystemUser> systemUsers = new LinkedHashSet<SystemUser>();
    private final Map<String, List<Acl>> acls = new HashMap<String, List<Acl>>();
    private List<String> nodetypeRegistrationSentences = new LinkedList<String>();
    private Set<String> privileges = new LinkedHashSet<String>();

    @Override
    public boolean addSystemUser(SystemUser systemUser) {
        if (this.preProvidedSystemUsers.add(systemUser)) {
            return this.systemUsers.add(systemUser);
        }
        return false;
    }

    @Override
    public boolean addAcl(String systemUser, Acl acl) {
        if (this.getSystemUser(systemUser).isPresent()) {
            this.acls.computeIfAbsent(systemUser, k -> new LinkedList()).add(acl);
            return true;
        }
        return false;
    }

    private void addPath(Path path, Set<Path> paths) {
        Path parent;
        if (this.preProvidedPaths.add(path)) {
            paths.add(path);
        }
        if ((parent = path.getParent()) != null && parent.getNameCount() > 0) {
            this.addPath(parent, paths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepoinitExtension(List<VaultPackageAssembler> packageAssemblers, FeaturesManager featureManager) {
        try (Formatter formatter = null;){
            formatter = new Formatter();
            if (!this.privileges.isEmpty()) {
                for (String string : this.privileges) {
                    formatter.format("register privilege %s%n", string);
                }
            }
            for (String string : this.nodetypeRegistrationSentences) {
                formatter.format("%s%n", string);
            }
            for (SystemUser systemUser : this.systemUsers) {
                this.addSystemUserPath(formatter, systemUser.getPath());
                formatter.format("create service user %s with path %s%n", systemUser.getId(), systemUser.getPath());
                List<Acl> authorizations = this.acls.remove(systemUser.getId());
                this.addStatements(systemUser, authorizations, packageAssemblers, formatter);
            }
            for (Map.Entry entry : this.acls.entrySet()) {
                Optional<SystemUser> systemUser = this.getSystemUser((String)entry.getKey());
                if (!systemUser.isPresent()) continue;
                List authorizations = (List)entry.getValue();
                this.addStatements(systemUser.get(), authorizations, packageAssemblers, formatter);
            }
            String text = formatter.toString();
            if (!text.isEmpty()) {
                featureManager.addOrAppendRepoInitExtension(text, null);
            }
        }
    }

    private void addStatements(SystemUser systemUser, List<Acl> authorizations, List<VaultPackageAssembler> packageAssemblers, Formatter formatter) {
        if (authorizations != null) {
            Iterator<Acl> authorizationsIterator = authorizations.iterator();
            while (authorizationsIterator.hasNext()) {
                Acl acl = authorizationsIterator.next();
                if (!acl.getPath().startsWith(systemUser.getPath())) continue;
                authorizationsIterator.remove();
            }
        }
        this.addPaths(authorizations, packageAssemblers, formatter);
        DefaultAclManager.addAclStatement(formatter, systemUser.getId(), authorizations);
    }

    private Optional<SystemUser> getSystemUser(String id) {
        for (SystemUser systemUser : this.preProvidedSystemUsers) {
            if (!id.equals(systemUser.getId())) continue;
            return Optional.of(systemUser);
        }
        return Optional.empty();
    }

    private final void addSystemUserPath(Formatter formatter, Path path) {
        if (this.preProvidedSystemPaths.add(path)) {
            formatter.format("create path (rep:AuthorizableFolder) %s%n", path);
        }
    }

    @Override
    public void addNodetypeRegistrationSentence(String nodetypeRegistrationSentence) {
        if (nodetypeRegistrationSentence != null) {
            this.nodetypeRegistrationSentences.add(nodetypeRegistrationSentence);
        }
    }

    @Override
    public void addPrivilege(String privilege) {
        this.privileges.add(privilege);
    }

    @Override
    public void reset() {
        this.systemUsers.clear();
        this.acls.clear();
        this.nodetypeRegistrationSentences.clear();
        this.privileges.clear();
    }

    private void addPaths(List<Acl> authorizations, List<VaultPackageAssembler> packageAssemblers, Formatter formatter) {
        if (DefaultAclManager.areEmpty(authorizations)) {
            return;
        }
        TreeSet<Path> paths = new TreeSet<Path>();
        for (Acl authorization : authorizations) {
            this.addPath(authorization.getRepositoryPath(), paths);
        }
        for (Path path : paths) {
            String type = DefaultAclManager.computePathType(path, packageAssemblers);
            formatter.format("create path (%s) %s%n", type, path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String computePathType(Path path, List<VaultPackageAssembler> packageAssemblers) {
        File currentContent;
        VaultPackageAssembler packageAssembler;
        File currentDir;
        path = Paths.get(PlatformNameFormat.getPlatformPath((String)path.toString()), new String[0]);
        Iterator<VaultPackageAssembler> iterator = packageAssemblers.iterator();
        do {
            if (!iterator.hasNext()) return DEFAULT_TYPE;
        } while (!(currentDir = (packageAssembler = iterator.next()).getEntry(path.toString())).exists() || !(currentContent = new File(currentDir, CONTENT_XML_FILE_NAME)).exists());
        try (FileInputStream input = new FileInputStream(currentContent);){
            String string = (String)new PrimaryTypeParser(DEFAULT_TYPE).parse(input);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("A fatal error occurred while parsing the '" + currentContent + "' file, see nested exceptions: " + e);
        }
    }

    private static void addAclStatement(Formatter formatter, String systemUser, List<Acl> authorizations) {
        if (authorizations == null || DefaultAclManager.areEmpty(authorizations)) {
            return;
        }
        formatter.format("set ACL for %s%n", systemUser);
        for (Acl authorization : authorizations) {
            formatter.format("%s %s on %s", authorization.getOperation(), authorization.getPrivileges(), authorization.getRepositoryPath());
            if (!authorization.getRestrictions().isEmpty()) {
                formatter.format(" restriction(%s)", authorization.getRestrictions().stream().collect(Collectors.joining(",")));
            }
            formatter.format("%n", new Object[0]);
        }
        formatter.format("end%n", new Object[0]);
    }

    private static boolean areEmpty(List<Acl> authorizations) {
        return authorizations == null || authorizations.isEmpty();
    }
}

