/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.regex.Matcher;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.AbstractRegexEntryHandler;
import org.osgi.util.converter.Converters;

abstract class AbstractConfigurationEntryHandler
extends AbstractRegexEntryHandler {
    private static final String REPOINIT_FACTORY_PID = "org.apache.sling.jcr.repoinit.RepositoryInitializer";
    private static final String REPOINIT_PID = "org.apache.sling.jcr.repoinit.impl.RepositoryInitializer ";

    public AbstractConfigurationEntryHandler(String extension) {
        super("/jcr_root/(?:apps|libs)/.+/config(\\.(?<runmode>[^/]+))?/(?<pid>.*)\\." + extension);
    }

    @Override
    public final void handle(String path, Archive archive, Archive.Entry entry, ContentPackage2FeatureModelConverter converter) throws Exception {
        Matcher matcher = this.getPattern().matcher(path);
        String runMode = null;
        if (matcher.matches()) {
            Dictionary<String, Object> configurationProperties;
            String id;
            String pid = matcher.group("pid");
            int idx = pid.lastIndexOf(47);
            if (idx != -1) {
                pid = pid.substring(idx + 1);
            }
            String factoryPid = null;
            int n = pid.indexOf(126);
            if (n == -1) {
                n = pid.indexOf(45);
            }
            if (n > 0) {
                factoryPid = pid.substring(0, n);
                id = factoryPid.concat("~").concat(pid.substring(n + 1));
            } else {
                id = pid;
            }
            this.logger.info("Processing configuration '{}'.", (Object)id);
            try (InputStream input = archive.openInputStream(entry);){
                configurationProperties = this.parseConfiguration(id, input);
            }
            if (configurationProperties == null) {
                this.logger.info("{} entry does not contain a valid OSGi configuration, treating it as a regular resource", (Object)path);
                converter.getMainPackageAssembler().addEntry(path, archive, entry);
                return;
            }
            runMode = matcher.group("runmode");
            if (REPOINIT_FACTORY_PID.equals(factoryPid)) {
                String[] references;
                CharSequence[] scripts = (String[])Converters.standardConverter().convert(configurationProperties.get("scripts")).to(String[].class);
                if (scripts != null && scripts.length > 0) {
                    String text = String.join((CharSequence)"\n", scripts);
                    converter.getFeaturesManager().addOrAppendRepoInitExtension(text, runMode);
                }
                if ((references = (String[])Converters.standardConverter().convert(configurationProperties.get("references")).to(String[].class)) != null && references.length > 0) {
                    throw new IllegalArgumentException("References are not supported for repoinit (factory configuration " + pid + ")");
                }
            } else if (REPOINIT_PID.equals(pid)) {
                String[] references = (String[])Converters.standardConverter().convert(configurationProperties.get("references")).to(String[].class);
                if (references != null && references.length > 0) {
                    throw new IllegalArgumentException("References are not supported for repoinit (configuration " + pid + ")");
                }
            } else {
                converter.getFeaturesManager().addConfiguration(runMode, id, configurationProperties);
            }
        } else {
            throw new IllegalStateException("Something went terribly wrong: pattern '" + this.getPattern().pattern() + "' should have matched already with path '" + path + "' but it does not, currently");
        }
    }

    protected abstract Dictionary<String, Object> parseConfiguration(String var1, InputStream var2) throws Exception;
}

